package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerListBuilder extends VerticalPodAutoscalerListFluentImpl<VerticalPodAutoscalerListBuilder> implements VisitableBuilder<VerticalPodAutoscalerList,VerticalPodAutoscalerListBuilder>{
  public VerticalPodAutoscalerListBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerListBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerList(), validationEnabled);
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerList(), validationEnabled);
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerListFluent<?> fluent,VerticalPodAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerListFluent<?> fluent,VerticalPodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerList instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerListBuilder(VerticalPodAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerListFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerList build() {
    VerticalPodAutoscalerList buildable = new VerticalPodAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}