package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VerticalPodAutoscalerBuilder extends VerticalPodAutoscalerFluent<VerticalPodAutoscalerBuilder> implements VisitableBuilder<VerticalPodAutoscaler,VerticalPodAutoscalerBuilder>{
  public VerticalPodAutoscalerBuilder() {
    this(new VerticalPodAutoscaler());
  }
  
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent) {
    this(fluent, new VerticalPodAutoscaler());
  }
  
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent,VerticalPodAutoscaler instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscaler instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VerticalPodAutoscalerFluent<?> fluent;
  
  public VerticalPodAutoscaler build() {
    VerticalPodAutoscaler buildable = new VerticalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}