package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RecommendedContainerResourcesBuilder extends RecommendedContainerResourcesFluent<RecommendedContainerResourcesBuilder> implements VisitableBuilder<RecommendedContainerResources,RecommendedContainerResourcesBuilder>{
  public RecommendedContainerResourcesBuilder() {
    this(new RecommendedContainerResources());
  }
  
  public RecommendedContainerResourcesBuilder(RecommendedContainerResourcesFluent<?> fluent) {
    this(fluent, new RecommendedContainerResources());
  }
  
  public RecommendedContainerResourcesBuilder(RecommendedContainerResourcesFluent<?> fluent,RecommendedContainerResources instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RecommendedContainerResourcesBuilder(RecommendedContainerResources instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RecommendedContainerResourcesFluent<?> fluent;
  
  public RecommendedContainerResources build() {
    RecommendedContainerResources buildable = new RecommendedContainerResources(fluent.getContainerName(),fluent.getLowerBound(),fluent.getTarget(),fluent.getUncappedTarget(),fluent.getUpperBound());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}