package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodUpdatePolicyBuilder extends PodUpdatePolicyFluent<PodUpdatePolicyBuilder> implements VisitableBuilder<PodUpdatePolicy,PodUpdatePolicyBuilder>{
  public PodUpdatePolicyBuilder() {
    this(new PodUpdatePolicy());
  }
  
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent) {
    this(fluent, new PodUpdatePolicy());
  }
  
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent,PodUpdatePolicy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodUpdatePolicyBuilder(PodUpdatePolicy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodUpdatePolicyFluent<?> fluent;
  
  public PodUpdatePolicy build() {
    PodUpdatePolicy buildable = new PodUpdatePolicy(fluent.getUpdateMode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}