package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Double;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HistogramCheckpointFluent<A extends HistogramCheckpointFluent<A>> extends BaseFluent<A>{
  public HistogramCheckpointFluent() {
  }
  
  public HistogramCheckpointFluent(HistogramCheckpoint instance) {
    this.copyInstance(instance);
  }
  private Map<Integer,Long> bucketWeights;
  private String referenceTimestamp;
  private Double totalWeight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HistogramCheckpoint instance) {
    instance = (instance != null ? instance : new HistogramCheckpoint());
    if (instance != null) {
          this.withBucketWeights(instance.getBucketWeights());
          this.withReferenceTimestamp(instance.getReferenceTimestamp());
          this.withTotalWeight(instance.getTotalWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBucketWeights(Integer key,Long value) {
    if(this.bucketWeights == null && key != null && value != null) { this.bucketWeights = new LinkedHashMap(); }
    if(key != null && value != null) {this.bucketWeights.put(key, value);} return (A)this;
  }
  
  public A addToBucketWeights(Map<Integer,Long> map) {
    if(this.bucketWeights == null && map != null) { this.bucketWeights = new LinkedHashMap(); }
    if(map != null) { this.bucketWeights.putAll(map);} return (A)this;
  }
  
  public A removeFromBucketWeights(Integer key) {
    if(this.bucketWeights == null) { return (A) this; }
    if(key != null && this.bucketWeights != null) {this.bucketWeights.remove(key);} return (A)this;
  }
  
  public A removeFromBucketWeights(Map<Integer,Long> map) {
    if(this.bucketWeights == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.bucketWeights != null){this.bucketWeights.remove(key);}}} return (A)this;
  }
  
  public Map<Integer,Long> getBucketWeights() {
    return this.bucketWeights;
  }
  
  public <K,V>A withBucketWeights(Map<Integer,Long> bucketWeights) {
    if (bucketWeights == null) {
      this.bucketWeights = null;
    } else {
      this.bucketWeights = new LinkedHashMap(bucketWeights);
    }
    return (A) this;
  }
  
  public boolean hasBucketWeights() {
    return this.bucketWeights != null;
  }
  
  public String getReferenceTimestamp() {
    return this.referenceTimestamp;
  }
  
  public A withReferenceTimestamp(String referenceTimestamp) {
    this.referenceTimestamp = referenceTimestamp;
    return (A) this;
  }
  
  public boolean hasReferenceTimestamp() {
    return this.referenceTimestamp != null;
  }
  
  public Double getTotalWeight() {
    return this.totalWeight;
  }
  
  public A withTotalWeight(Double totalWeight) {
    this.totalWeight = totalWeight;
    return (A) this;
  }
  
  public boolean hasTotalWeight() {
    return this.totalWeight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HistogramCheckpointFluent that = (HistogramCheckpointFluent) o;
    if (!java.util.Objects.equals(bucketWeights, that.bucketWeights)) return false;
    if (!java.util.Objects.equals(referenceTimestamp, that.referenceTimestamp)) return false;
    if (!java.util.Objects.equals(totalWeight, that.totalWeight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bucketWeights,  referenceTimestamp,  totalWeight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bucketWeights != null && !bucketWeights.isEmpty()) { sb.append("bucketWeights:"); sb.append(bucketWeights + ","); }
    if (referenceTimestamp != null) { sb.append("referenceTimestamp:"); sb.append(referenceTimestamp + ","); }
    if (totalWeight != null) { sb.append("totalWeight:"); sb.append(totalWeight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}