package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HistogramCheckpointBuilder extends HistogramCheckpointFluent<HistogramCheckpointBuilder> implements VisitableBuilder<HistogramCheckpoint,HistogramCheckpointBuilder>{
  public HistogramCheckpointBuilder() {
    this(new HistogramCheckpoint());
  }
  
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent) {
    this(fluent, new HistogramCheckpoint());
  }
  
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent,HistogramCheckpoint instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HistogramCheckpointBuilder(HistogramCheckpoint instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HistogramCheckpointFluent<?> fluent;
  
  public HistogramCheckpoint build() {
    HistogramCheckpoint buildable = new HistogramCheckpoint(fluent.getBucketWeights(),fluent.getReferenceTimestamp(),fluent.getTotalWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}