package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ContainerResourcePolicyBuilder extends ContainerResourcePolicyFluent<ContainerResourcePolicyBuilder> implements VisitableBuilder<ContainerResourcePolicy,ContainerResourcePolicyBuilder>{
  public ContainerResourcePolicyBuilder() {
    this(new ContainerResourcePolicy());
  }
  
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent) {
    this(fluent, new ContainerResourcePolicy());
  }
  
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent,ContainerResourcePolicy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ContainerResourcePolicyBuilder(ContainerResourcePolicy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ContainerResourcePolicyFluent<?> fluent;
  
  public ContainerResourcePolicy build() {
    ContainerResourcePolicy buildable = new ContainerResourcePolicy(fluent.getContainerName(),fluent.getControlledResources(),fluent.getControlledValues(),fluent.getMaxAllowed(),fluent.getMinAllowed(),fluent.getMode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}