package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerCheckpointStatusBuilder extends VerticalPodAutoscalerCheckpointStatusFluentImpl<VerticalPodAutoscalerCheckpointStatusBuilder> implements VisitableBuilder<io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus,io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatusBuilder>{
  public VerticalPodAutoscalerCheckpointStatusBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerCheckpointStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerCheckpointStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCpuHistogram(instance.getCpuHistogram()); 
    fluent.withFirstSampleStart(instance.getFirstSampleStart()); 
    fluent.withLastSampleStart(instance.getLastSampleStart()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMemoryHistogram(instance.getMemoryHistogram()); 
    fluent.withTotalSamplesCount(instance.getTotalSamplesCount()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCpuHistogram(instance.getCpuHistogram()); 
    this.withFirstSampleStart(instance.getFirstSampleStart()); 
    this.withLastSampleStart(instance.getLastSampleStart()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMemoryHistogram(instance.getMemoryHistogram()); 
    this.withTotalSamplesCount(instance.getTotalSamplesCount()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCheckpointStatus build() {
    VerticalPodAutoscalerCheckpointStatus buildable = new VerticalPodAutoscalerCheckpointStatus(fluent.getCpuHistogram(),fluent.getFirstSampleStart(),fluent.getLastSampleStart(),fluent.getLastUpdateTime(),fluent.getMemoryHistogram(),fluent.getTotalSamplesCount(),fluent.getVersion());
    return buildable;
  }
  
}