package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodUpdatePolicyBuilder extends PodUpdatePolicyFluentImpl<PodUpdatePolicyBuilder> implements VisitableBuilder<PodUpdatePolicy,io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyBuilder>{
  public PodUpdatePolicyBuilder() {
    this(false);
  }
  public PodUpdatePolicyBuilder(Boolean validationEnabled) {
    this(new PodUpdatePolicy(), validationEnabled);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PodUpdatePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodUpdatePolicy(), validationEnabled);
  }
  public PodUpdatePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy instance) {
    this(fluent, instance, false);
  }
  public PodUpdatePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withUpdateMode(instance.getUpdateMode()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodUpdatePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy instance) {
    this(instance,false);
  }
  public PodUpdatePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withUpdateMode(instance.getUpdateMode()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy build() {
    PodUpdatePolicy buildable = new PodUpdatePolicy(fluent.getUpdateMode());
    return buildable;
  }
  
}