package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodResourcePolicyBuilder extends PodResourcePolicyFluentImpl<PodResourcePolicyBuilder> implements VisitableBuilder<io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy,io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyBuilder>{
  public PodResourcePolicyBuilder() {
    this(false);
  }
  public PodResourcePolicyBuilder(Boolean validationEnabled) {
    this(new PodResourcePolicy(), validationEnabled);
  }
  public PodResourcePolicyBuilder(PodResourcePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PodResourcePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodResourcePolicy(), validationEnabled);
  }
  public PodResourcePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy instance) {
    this(fluent, instance, false);
  }
  public PodResourcePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent<?> fluent,io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerPolicies(instance.getContainerPolicies()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodResourcePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy instance) {
    this(instance,false);
  }
  public PodResourcePolicyBuilder(io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerPolicies(instance.getContainerPolicies()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy build() {
    PodResourcePolicy buildable = new PodResourcePolicy(fluent.getContainerPolicies());
    return buildable;
  }
  
}