
package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bucketWeights",
    "referenceTimestamp",
    "totalWeight"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class HistogramCheckpoint implements KubernetesResource
{

    @JsonProperty("bucketWeights")
    private Map<Integer, Long> bucketWeights;
    @JsonProperty("referenceTimestamp")
    private String referenceTimestamp;
    @JsonProperty("totalWeight")
    private Object totalWeight;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public HistogramCheckpoint() {
    }

    /**
     * 
     * @param referenceTimestamp
     * @param bucketWeights
     * @param totalWeight
     */
    public HistogramCheckpoint(Map<Integer, Long> bucketWeights, String referenceTimestamp, Object totalWeight) {
        super();
        this.bucketWeights = bucketWeights;
        this.referenceTimestamp = referenceTimestamp;
        this.totalWeight = totalWeight;
    }

    @JsonProperty("bucketWeights")
    public Map<Integer, Long> getBucketWeights() {
        return bucketWeights;
    }

    @JsonProperty("bucketWeights")
    public void setBucketWeights(Map<Integer, Long> bucketWeights) {
        this.bucketWeights = bucketWeights;
    }

    @JsonProperty("referenceTimestamp")
    public String getReferenceTimestamp() {
        return referenceTimestamp;
    }

    @JsonProperty("referenceTimestamp")
    public void setReferenceTimestamp(String referenceTimestamp) {
        this.referenceTimestamp = referenceTimestamp;
    }

    @JsonProperty("totalWeight")
    public Object getTotalWeight() {
        return totalWeight;
    }

    @JsonProperty("totalWeight")
    public void setTotalWeight(Object totalWeight) {
        this.totalWeight = totalWeight;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
