/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.maven;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.maven.support.MavenHelper;
import io.fabric8.updatebot.model.Dependencies;
import io.fabric8.updatebot.model.GitRepositoryConfig;
import io.fabric8.updatebot.model.MavenArtifactKey;
import io.fabric8.updatebot.model.MavenArtifactVersionChange;
import io.fabric8.updatebot.model.MavenArtifactVersionChanges;
import io.fabric8.updatebot.model.MavenDependencies;
import io.fabric8.updatebot.model.MavenDependencyFilter;
import io.fabric8.updatebot.model.RepositoryConfig;
import io.fabric8.updatebot.model.RepositoryConfigs;
import io.fabric8.updatebot.support.MarkupHelper;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="export", aggregator=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExportVersionsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="updateBotYaml")
    protected String configYaml;
    @Parameter(property="destFile", defaultValue="${basedir}/target/updatebot-versions.yml")
    protected File destFile;
    private RepositoryConfig repositoryConfig;

    protected static void addArtifact(Map<MavenArtifactKey, MavenArtifactVersionChange> exportVersions, MavenArtifactKey artifactKey, String version, String scope) {
        exportVersions.put(artifactKey, new MavenArtifactVersionChange(artifactKey, version, scope));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List dependencies;
        Dependencies push;
        GitRepositoryConfig config;
        Log log = this.getLog();
        File sourceDir = this.project.getBasedir();
        Configuration configuration = new Configuration();
        configuration.setSourceDir(sourceDir);
        try {
            this.repositoryConfig = RepositoryConfigs.loadRepositoryConfig((Configuration)configuration, (String)this.configYaml, (File)sourceDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load updatebot.yml file from " + this.configYaml + ". " + e, (Exception)e);
        }
        try {
            config = RepositoryConfigs.getGitHubRepositoryDetails((RepositoryConfig)this.repositoryConfig, (File)sourceDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find GitRepositoryConfig from updatebot.yml file " + this.configYaml + ". " + e, (Exception)e);
        }
        log.debug((CharSequence)("Loaded git config " + config + " from " + sourceDir));
        MavenDependencies mavenDependencies = null;
        if (config != null && (push = config.getPush()) != null) {
            mavenDependencies = push.getMaven();
        }
        Filter dependencyFilter = Filters.falseFilter();
        if (mavenDependencies != null && (dependencies = mavenDependencies.getDependencies()) != null) {
            dependencyFilter = MavenDependencyFilter.createFilter((List)dependencies);
        }
        TreeMap<MavenArtifactKey, MavenArtifactVersionChange> exportVersions = new TreeMap<MavenArtifactKey, MavenArtifactVersionChange>();
        List projects = this.project.getCollectedProjects();
        for (MavenProject project : projects) {
            MavenArtifactKey artifactKey = new MavenArtifactKey(project.getGroupId(), project.getArtifactId());
            ExportVersionsMojo.addArtifact(exportVersions, artifactKey, project.getVersion(), "artifact");
            log.debug((CharSequence)("Collected project : " + project));
            List dependencies2 = project.getDependencies();
            for (Dependency dependency : dependencies2) {
                MavenArtifactKey dependencyKey = MavenHelper.toMavenDependency(dependency);
                if (!dependencyFilter.matches((Object)dependencyKey)) continue;
                log.debug((CharSequence)("    dependency: " + dependency));
                ExportVersionsMojo.addArtifact(exportVersions, dependencyKey, dependency.getVersion(), "dependency");
            }
        }
        this.destFile.getParentFile().mkdirs();
        try {
            MavenArtifactVersionChanges changes = new MavenArtifactVersionChanges(exportVersions.values());
            MarkupHelper.saveYaml((Object)changes, (File)this.destFile);
            log.info((CharSequence)("Generated updatebot version file " + this.destFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + this.destFile + ". " + e, (Exception)e);
        }
    }
}

