/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.support;

import io.fabric8.updatebot.support.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Systems {
    private static final transient Logger LOG = LoggerFactory.getLogger(Systems.class);

    public static String getConfigValue(String envVar) {
        return Systems.getConfigValue(envVar, null);
    }

    public static String getConfigValue(String envVar, String defaultValue) {
        String systemProperty = envVar.toLowerCase().replace('_', '.');
        String answer = System.getProperty(systemProperty);
        if (Strings.notEmpty(answer)) {
            return answer;
        }
        try {
            answer = System.getenv(envVar);
        }
        catch (Exception e) {
            LOG.warn("Failed to look up environment variable $" + envVar + ". " + e, (Throwable)e);
        }
        if (Strings.notEmpty(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static boolean isConfigFlag(String envVar) {
        String value = Systems.getConfigValue(envVar);
        return value != null && value.equalsIgnoreCase("true");
    }
}

