/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.support;

import io.fabric8.utils.Filter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(ReflectionHelper.class);

    public static List<Field> findFieldsAnnotatedWith(Class<?> type, final Class<? extends Annotation> annotationClass) {
        return ReflectionHelper.findFieldsMatching(type, new Filter<Field>(){

            public boolean matches(Field field) {
                Object annotation = field.getAnnotation(annotationClass);
                return annotation != null;
            }

            public String toString() {
                return "HasAnnotation(" + annotationClass.getName() + ")";
            }
        });
    }

    public static List<Field> findFieldsMatching(Class<?> type, Filter<Field> filter) {
        ArrayList<Field> answer = new ArrayList<Field>();
        ReflectionHelper.appendFieldsAnnotatatedWith(answer, type, filter);
        return answer;
    }

    protected static void appendFieldsAnnotatatedWith(List<Field> list, Class<?> type, Filter<Field> filter) {
        Field[] fields = type.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                if (!filter.matches((Object)field)) continue;
                list.add(field);
            }
        }
        if (type.getSuperclass() != null) {
            ReflectionHelper.appendFieldsAnnotatatedWith(list, type.getSuperclass(), filter);
        }
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Could not access " + field + " on " + instance + ". " + e, (Throwable)e);
            return null;
        }
    }
}

