/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.support;

import io.fabric8.updatebot.Configuration;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessHelper.class);

    public static int runCommand(File dir, String ... commands) {
        return ProcessHelper.runCommand(dir, true, commands);
    }

    public static int runCommandIgnoreOutput(File dir, String ... commands) {
        return ProcessHelper.runCommand(dir, false, commands);
    }

    public static int runCommand(File dir, boolean inheritIO, String ... commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.directory(dir);
        if (inheritIO) {
            builder.inheritIO();
        }
        return ProcessHelper.doRunCommand(builder, commands);
    }

    public static String runCommandCaptureOutput(File dir, String ... commands) throws IOException {
        File errorFile;
        File outputFile;
        try {
            outputFile = File.createTempFile("updatebot-", ".log");
            errorFile = File.createTempFile("updatebot-", ".err");
        }
        catch (IOException e) {
            throw new IOException("Failed to create temporary files " + e, e);
        }
        int result = ProcessHelper.runCommand(dir, outputFile, errorFile, commands);
        String output = ProcessHelper.loadFile(outputFile);
        String err = ProcessHelper.loadFile(errorFile);
        ProcessHelper.logOutput(err, true);
        if (result != 0) {
            LOG.warn("Failed to run commands " + String.join((CharSequence)" ", commands) + " result: " + result);
            ProcessHelper.logOutput(output, false);
            throw new IOException("Failed to run commands " + String.join((CharSequence)" ", commands) + " result: " + result);
        }
        return output;
    }

    public static int runCommand(File dir, File outputFile, File errorFile, String ... commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.directory(dir);
        builder.redirectOutput(outputFile);
        builder.redirectError(errorFile);
        return ProcessHelper.doRunCommand(builder, commands);
    }

    protected static int doRunCommand(ProcessBuilder builder, String[] commands) {
        String line = String.join((CharSequence)" ", commands);
        try {
            Process process = builder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LOG.warn("Failed to run command " + line + " in " + builder.directory() + " : exit " + exitCode);
            }
            return exitCode;
        }
        catch (IOException e) {
            LOG.warn("Failed to run command " + line + " in " + builder.directory() + " : error " + e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 1;
    }

    public static boolean runCommandAndLogOutput(File dir, String ... commands) {
        File outputFile = new File(dir, "target/updatebot.log");
        File errorFile = new File(dir, "target/updatebot.err");
        outputFile.getParentFile().mkdirs();
        boolean answer = true;
        if (ProcessHelper.runCommand(dir, outputFile, errorFile, commands) != 0) {
            LOG.warn("Failed to run " + String.join((CharSequence)" ", commands));
            answer = false;
        }
        ProcessHelper.logOutput(outputFile, false);
        ProcessHelper.logOutput(errorFile, true);
        return answer;
    }

    public static boolean runCommandAndLogOutput(Configuration configuration, Logger log, File dir, String ... commands) {
        File outputFile = new File(dir, "target/updatebot.log");
        File errorFile = new File(dir, "target/updatebot.err");
        outputFile.getParentFile().mkdirs();
        boolean answer = true;
        if (ProcessHelper.runCommand(dir, outputFile, errorFile, commands) != 0) {
            LOG.warn("Failed to run " + String.join((CharSequence)" ", commands));
            answer = false;
        }
        ProcessHelper.logOutput(configuration, log, outputFile, false);
        ProcessHelper.logOutput(configuration, log, errorFile, true);
        return answer;
    }

    public static void logOutput(Configuration configuration, Logger log, File file, boolean error) {
        ProcessHelper.logOutput(configuration, log, ProcessHelper.loadFile(file), error);
    }

    public static void logOutput(File file, boolean error) {
        ProcessHelper.logOutput(ProcessHelper.loadFile(file), error);
    }

    protected static void logOutput(String output, boolean error) {
        if (Strings.notEmpty((String)output)) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                if (error) {
                    LOG.error(line);
                    continue;
                }
                LOG.info(line);
            }
        }
    }

    protected static void logOutput(Configuration configuration, Logger log, String output, boolean error) {
        if (Strings.notEmpty((String)output)) {
            String[] lines;
            for (String line : lines = output.split("\n")) {
                if (error) {
                    configuration.info(log, line);
                    continue;
                }
                configuration.warn(log, line);
            }
        }
    }

    protected static String loadFile(File file) {
        String output = null;
        if (Files.isFile((File)file)) {
            try {
                output = IOHelpers.readFully((File)file);
            }
            catch (IOException e) {
                LOG.error("Failed to load " + file + ". " + e, (Throwable)e);
            }
        }
        return output;
    }
}

