/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.support;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.updatebot.support.NpmJsonPrettyPrinter;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.tools.FileObject;

public class MarkupHelper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper createYamlObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return objectMapper;
    }

    public static String toJson(Object dto) throws JsonProcessingException {
        if (dto == null) {
            return "null";
        }
        Class<?> clazz = dto.getClass();
        return OBJECT_MAPPER.writerFor(clazz).writeValueAsString(dto);
    }

    public static String toPrettyJson(Object dto) throws JsonProcessingException {
        if (dto == null) {
            return "null";
        }
        Class<?> clazz = dto.getClass();
        ObjectMapper objectMapper = MarkupHelper.createPrettyJsonObjectMapper();
        return objectMapper.writerFor(clazz).writeValueAsString(dto);
    }

    protected static ObjectMapper createPrettyJsonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper;
    }

    public static <T> T loadYaml(File file, Class<T> clazz) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        return (T)mapper.readValue(file, clazz);
    }

    public static <T> T loadYaml(URL src, Class<T> clazz) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        return (T)mapper.readValue(src, clazz);
    }

    public static <T> T loadYaml(InputStream in, Class<T> clazz) throws IOException {
        byte[] data = Files.readBytes((InputStream)in);
        return MarkupHelper.loadYaml(data, clazz);
    }

    public static <T> T loadYaml(String text, Class<T> clazz) throws IOException {
        byte[] data = text.getBytes();
        return MarkupHelper.loadYaml(data, clazz);
    }

    public static <T> T loadYaml(byte[] data, Class<T> clazz) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        return (T)mapper.readValue(data, clazz);
    }

    public static void saveYaml(Object data, File file) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        mapper.writeValue(file, data);
    }

    public static void saveYaml(Object data, FileObject fileObject) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        try (Writer writer = fileObject.openWriter();){
            mapper.writeValue(writer, data);
        }
    }

    public static String toYaml(Object data) throws IOException {
        ObjectMapper mapper = MarkupHelper.createYamlObjectMapper();
        return mapper.writeValueAsString(data);
    }

    public static JsonNode loadJson(File file) throws IOException {
        return OBJECT_MAPPER.readTree(file);
    }

    public static void savePrettyJson(File file, Object value) throws IOException {
        NpmJsonPrettyPrinter printer = new NpmJsonPrettyPrinter();
        ObjectMapper objectMapper = MarkupHelper.createPrettyJsonObjectMapper();
        objectMapper.setDefaultPrettyPrinter((PrettyPrinter)printer);
        String json = objectMapper.writer().writeValueAsString(value);
        IOHelpers.writeFully((File)file, (String)(json + System.lineSeparator()));
    }
}

