/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.support;

import io.fabric8.updatebot.support.GitRepositoryInfo;
import io.fabric8.utils.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitHelper.class);

    public static List<String> getGitHubCloneUrls(String gitHubHost, String orgName, String repository) {
        ArrayList<String> answer = new ArrayList<String>();
        answer.add("https://" + gitHubHost + "/" + orgName + "/" + repository);
        answer.add("git@" + gitHubHost + ":" + orgName + "/" + repository);
        answer.add("git://" + gitHubHost + "/" + orgName + "/" + repository);
        ArrayList copy = new ArrayList(answer);
        for (String url : copy) {
            if (url.endsWith(".git")) continue;
            answer.add(url + ".git");
        }
        return answer;
    }

    public static GitRepositoryInfo parseGitRepositoryInfo(String gitUrl) {
        if (Strings.isNullOrBlank((String)gitUrl)) {
            return null;
        }
        try {
            String[] paths;
            URI url = new URI(gitUrl);
            String host = url.getHost();
            String userInfo = url.getUserInfo();
            String path = url.getPath();
            path = GitHelper.stripSlashesAndGit(path);
            if (Strings.notEmpty((String)userInfo)) {
                return new GitRepositoryInfo(host, userInfo, path);
            }
            if (Strings.notEmpty((String)path) && (paths = path.split("/", 2)).length > 1) {
                return new GitRepositoryInfo(host, paths[0], paths[1]);
            }
            return null;
        }
        catch (URISyntaxException url) {
            String prefix = "git@";
            if (gitUrl.startsWith(prefix)) {
                String path = Strings.stripPrefix((String)gitUrl, (String)prefix);
                String[] paths = (path = GitHelper.stripSlashesAndGit(path)).split(":|/", 3);
                if (paths.length == 3) {
                    return new GitRepositoryInfo(paths[0], paths[1], paths[2]);
                }
            }
            return null;
        }
    }

    protected static String stripSlashesAndGit(String path) {
        path = Strings.stripPrefix((String)path, (String)"/");
        path = Strings.stripPrefix((String)path, (String)"/");
        path = Strings.stripSuffix((String)path, (String)"/");
        path = Strings.stripSuffix((String)path, (String)".git");
        return path;
    }
}

