/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.repository;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandSupport;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.model.GitHubProjects;
import io.fabric8.updatebot.model.GitRepository;
import io.fabric8.updatebot.model.GitRepositoryConfig;
import io.fabric8.updatebot.model.GithubOrganisation;
import io.fabric8.updatebot.model.GithubRepository;
import io.fabric8.updatebot.model.RepositoryConfig;
import io.fabric8.updatebot.repository.LocalRepository;
import io.fabric8.updatebot.support.FileHelper;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Files;
import io.fabric8.utils.Filter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repositories {
    private static final transient Logger LOG = LoggerFactory.getLogger(Repositories.class);

    public static List<LocalRepository> cloneOrPullRepositories(CommandSupport command, Configuration configuration, RepositoryConfig repositoryConfig) throws IOException {
        List<LocalRepository> repositories = Repositories.findRepositories(command, configuration, repositoryConfig);
        for (LocalRepository repository : repositories) {
            Repositories.cloneOrPull(configuration, repository);
        }
        return repositories;
    }

    private static void cloneOrPull(Configuration configuration, LocalRepository repository) {
        File dir = repository.getDir();
        File gitDir = new File(dir, ".git");
        if (gitDir.exists()) {
            if (configuration.getGit().stashAndCheckoutMaster(dir) && !configuration.isPullDisabled()) {
                configuration.git.pull(dir, repository.getCloneUrl());
            }
        } else {
            File parentDir = dir.getParentFile();
            parentDir.mkdirs();
            configuration.info(LOG, "Cloning: " + repository.getFullName() + " to " + FileHelper.getRelativePathToCurrentDir(dir));
            configuration.git.clone(parentDir, repository.getCloneUrl(), dir.getName());
        }
    }

    protected static List<LocalRepository> findRepositories(CommandSupport updateBot, Configuration configuration, RepositoryConfig repositoryConfig) throws IOException {
        List<GitRepository> gitRepositories;
        List<GithubOrganisation> organisations;
        File sourceDir;
        String workDirPath = configuration.getWorkDir();
        File workDir = new File(workDirPath);
        if (!workDir.isAbsolute() && Files.isDirectory((File)(sourceDir = configuration.getSourceDir()))) {
            workDir = new File(sourceDir, workDirPath);
        }
        workDir.mkdirs();
        LinkedHashMap<String, LocalRepository> map = new LinkedHashMap<String, LocalRepository>();
        File gitHubDir = new File(workDir, "github");
        File gitDir = new File(workDir, "git");
        GitHubProjects githubProjects = repositoryConfig.getGithub();
        if (githubProjects != null && (organisations = githubProjects.getOrganisations()) != null && !organisations.isEmpty()) {
            GitHub github = configuration.getGithub();
            for (GithubOrganisation organisation : organisations) {
                Repositories.addGitHubRepositories(map, github, organisation, new File(gitHubDir, organisation.getName()));
            }
        }
        if ((gitRepositories = repositoryConfig.getGit()) != null) {
            for (GitRepository gitRepository : gitRepositories) {
                Repositories.addRepository(map, gitDir, gitRepository);
            }
        }
        return new ArrayList<LocalRepository>(map.values());
    }

    protected static void addRepository(Map<String, LocalRepository> map, File gitDir, GitRepository gitRepository) {
        LocalRepository localRepository = new LocalRepository(gitRepository, new File(gitDir, gitRepository.getName()));
        map.putIfAbsent(localRepository.getCloneUrl(), localRepository);
    }

    protected static void addGitHubRepositories(Map<String, LocalRepository> map, GitHub github, GithubOrganisation organisation, File file) {
        String orgName = organisation.getName();
        Filter<String> filter = organisation.createFilter();
        GHPerson person = GitHubHelpers.getOrganisationOrUser(github, orgName);
        if (person != null) {
            try {
                GithubRepository gitRepository;
                TreeSet<String> foundNames = new TreeSet<String>();
                List<GitRepositoryConfig> namedRepositories = organisation.getRepositories();
                if (namedRepositories != null) {
                    for (GitRepositoryConfig namedRepository : namedRepositories) {
                        String name = namedRepository.getName();
                        if (!Strings.notEmpty(name) || !foundNames.add(name)) continue;
                        GHRepository ghRepository = null;
                        try {
                            ghRepository = person.getRepository(name);
                        }
                        catch (IOException e) {
                            LOG.warn("Github repository " + orgName + "/" + name + " not found: " + e);
                            continue;
                        }
                        if (ghRepository != null) {
                            gitRepository = new GithubRepository(ghRepository, namedRepository);
                            Repositories.addRepository(map, file, gitRepository);
                            continue;
                        }
                        LOG.warn("Github repository " + orgName + "/" + name + " not found!");
                    }
                }
                Map repositories = person.getRepositories();
                for (Map.Entry entry : repositories.entrySet()) {
                    String repoName = (String)entry.getKey();
                    if (!filter.matches((Object)repoName) || !foundNames.add(repoName)) continue;
                    gitRepository = new GithubRepository((GHRepository)entry.getValue());
                    Repositories.addRepository(map, file, gitRepository);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to load organisation: " + orgName + ". " + e, (Throwable)e);
            }
        }
    }
}

