/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.repository;

import io.fabric8.updatebot.model.GitRepository;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.io.File;
import java.util.List;

public class LocalRepository {
    private GitRepository repo;
    private File dir;

    public LocalRepository(GitRepository repo, File dir) {
        this.repo = repo;
        this.dir = dir;
    }

    public static LocalRepository fromDirectory(File dir) {
        return new LocalRepository(new GitRepository(dir.getName()), dir);
    }

    public static LocalRepository findRepository(List<LocalRepository> localRepositories, String name) {
        if (localRepositories != null) {
            for (LocalRepository repository : localRepositories) {
                GitRepository repo = repository.getRepo();
                if (repo == null || !Objects.equal((Object)name, (Object)repo.getName())) continue;
                return repository;
            }
        }
        return null;
    }

    public static String getRepositoryLink(LocalRepository repository) {
        return LocalRepository.getRepositoryLink(repository, repository.getFullName());
    }

    public static String getRepositoryLink(LocalRepository repository, String label) {
        return LocalRepository.getRepositoryLink(repository, label, "`" + label + "`");
    }

    public static String getRepositoryLink(LocalRepository repository, String label, String defaultValue) {
        String htmlUrl;
        if (repository != null && Strings.notEmpty(htmlUrl = repository.getRepo().getHtmlUrl())) {
            return "[" + label + "](" + htmlUrl + ")";
        }
        if (Strings.notEmpty(defaultValue)) {
            return defaultValue;
        }
        return label;
    }

    public String toString() {
        return "LocalRepository{repo=" + this.repo + ", dir=" + this.dir + '}';
    }

    public String getFullName() {
        return this.repo.getFullName();
    }

    public GitRepository getRepo() {
        return this.repo;
    }

    public File getDir() {
        return this.dir;
    }

    public String getCloneUrl() {
        return this.repo.getCloneUrl();
    }

    public boolean hasCloneUrl(String cloneUrl) {
        return this.repo.hasCloneUrl(cloneUrl) || this.repo.hasCloneUrl(cloneUrl + ".git");
    }
}

