/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.model.GitRepositoryConfig;
import io.fabric8.updatebot.model.RepositoryConfig;
import io.fabric8.updatebot.support.MarkupHelper;
import io.fabric8.utils.Files;
import io.fabric8.utils.GitHelpers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class RepositoryConfigs {
    public static RepositoryConfig loadRepositoryConfig(String configFile, File sourceDir) throws IOException {
        File file = new File(configFile);
        if (Files.isDirectory((File)sourceDir) && !file.isAbsolute()) {
            file = new File(sourceDir, configFile);
        }
        if (!Files.isFile((File)file)) {
            URL url = null;
            try {
                url = new URL(configFile);
                InputStream in = null;
                try {
                    in = url.openStream();
                }
                catch (IOException e) {
                    throw new IOException("Failed to open URL " + configFile + ". " + e, e);
                }
                if (in != null) {
                    return MarkupHelper.loadYaml(in, RepositoryConfig.class);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            throw new FileNotFoundException(file.getCanonicalPath());
        }
        return MarkupHelper.loadYaml(file, RepositoryConfig.class);
    }

    public static GitRepositoryConfig getGitHubRepositoryDetails(RepositoryConfig repositoryConfig, File sourceDir) throws IOException {
        String cloneUrl = GitHelpers.extractGitUrl((File)sourceDir);
        if (cloneUrl != null) {
            return repositoryConfig.getRepositoryDetails(cloneUrl);
        }
        return null;
    }
}

