/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.model.MavenArtifactKey;
import io.fabric8.updatebot.support.FilterHelpers;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import java.util.ArrayList;
import java.util.List;

public class MavenDependencyFilter {
    private String groupInclude;
    private String groupExclude;
    private String artifactInclude;
    private String artifactExclude;

    protected static Filter<String> createStringFilter(String include, String exclude) {
        Filter includeFilter = null;
        Filter excludeFilter = null;
        if (Strings.notEmpty(include)) {
            includeFilter = Filters.createStringFilter((String)include);
        }
        if (Strings.notEmpty(exclude)) {
            excludeFilter = Filters.not((Filter)Filters.createStringFilter((String)exclude));
        }
        if (includeFilter == null && excludeFilter == null) {
            return Filters.trueFilter();
        }
        if (includeFilter == null) {
            return excludeFilter;
        }
        if (excludeFilter == null) {
            return includeFilter;
        }
        return FilterHelpers.and(includeFilter, excludeFilter);
    }

    public static Filter<MavenArtifactKey> createFilter(List<MavenDependencyFilter> dependencies) {
        ArrayList<Filter<MavenArtifactKey>> filters = new ArrayList<Filter<MavenArtifactKey>>();
        for (MavenDependencyFilter dependency : dependencies) {
            Filter<MavenArtifactKey> filter = dependency.createFilter();
            filters.add(filter);
        }
        if (filters.isEmpty()) {
            return Filters.falseFilter();
        }
        return Filters.or(filters);
    }

    public String getGroupInclude() {
        return this.groupInclude;
    }

    public void setGroupInclude(String groupInclude) {
        this.groupInclude = groupInclude;
    }

    public String getGroupExclude() {
        return this.groupExclude;
    }

    public void setGroupExclude(String groupExclude) {
        this.groupExclude = groupExclude;
    }

    public String getArtifactInclude() {
        return this.artifactInclude;
    }

    public void setArtifactInclude(String artifactInclude) {
        this.artifactInclude = artifactInclude;
    }

    public String getArtifactExclude() {
        return this.artifactExclude;
    }

    public void setArtifactExclude(String artifactExclude) {
        this.artifactExclude = artifactExclude;
    }

    public Filter<MavenArtifactKey> createFilter() {
        final Filter<String> groupFilter = MavenDependencyFilter.createStringFilter(this.groupInclude, this.groupExclude);
        final Filter<String> artifactFilter = MavenDependencyFilter.createStringFilter(this.artifactInclude, this.artifactExclude);
        final MavenDependencyFilter that = this;
        return new Filter<MavenArtifactKey>(){

            public String toString() {
                return "Filter(" + that + ")";
            }

            public boolean matches(MavenArtifactKey mavenArtifactKey) {
                return groupFilter.matches((Object)mavenArtifactKey.getGroupId()) && artifactFilter.matches((Object)mavenArtifactKey.getArtifactId());
            }
        };
    }
}

