/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.model.MavenArtifactKey;

public class MavenArtifactVersionChange {
    private String groupId;
    private String artifactId;
    private String version;
    private String scope;

    public MavenArtifactVersionChange() {
    }

    public MavenArtifactVersionChange(String groupId, String artifactId, String version, String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
    }

    public MavenArtifactVersionChange(MavenArtifactKey artifactKey, String version, String scope) {
        this(artifactKey.getGroupId(), artifactKey.getArtifactId(), version, scope);
    }

    public MavenArtifactVersionChange(DependencyVersionChange change) {
        this(MavenArtifactKey.fromString(change.getDependency()), change.getVersion(), change.getScope());
    }

    public String toString() {
        return "MavenArtifactVersionChange{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", scope='" + this.scope + '\'' + '}';
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public DependencyVersionChange createDependencyVersionChange() {
        return new DependencyVersionChange(Kind.MAVEN, new MavenArtifactKey(this.groupId, this.artifactId).toString(), this.version, this.scope);
    }
}

