/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

public class MavenArtifactKey
implements Comparable<MavenArtifactKey> {
    private final String groupId;
    private final String artifactId;

    public MavenArtifactKey(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public static MavenArtifactKey fromString(String value) {
        int idx = value.indexOf(58);
        if (idx < 0) {
            throw new IllegalArgumentException("No `:` character in the maven dependency: " + value);
        }
        return new MavenArtifactKey(value.substring(0, idx), value.substring(idx + 1));
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactKey that = (MavenArtifactKey)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        return this.artifactId.equals(that.artifactId);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        return result;
    }

    @Override
    public int compareTo(MavenArtifactKey that) {
        int answer = this.groupId.compareTo(that.groupId);
        if (answer == 0) {
            answer = this.artifactId.compareTo(that.artifactId);
        }
        return answer;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }
}

