/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.model.GitRepository;
import io.fabric8.updatebot.model.GitRepositoryConfig;
import io.fabric8.updatebot.support.Strings;
import java.net.URL;
import org.kohsuke.github.GHRepository;

public class GithubRepository
extends GitRepository {
    private final GHRepository repository;

    public GithubRepository(GHRepository repository) {
        this.repository = repository;
        URL htmlUrl = repository.getHtmlUrl();
        if (htmlUrl != null) {
            this.setHtmlUrl(htmlUrl.toString());
        }
        this.setName(repository.getName());
        this.setCloneUrl(repository.getGitTransportUrl());
    }

    public GithubRepository(GHRepository ghRepository, GitRepositoryConfig details) {
        this(ghRepository);
        this.setRepositoryDetails(details);
    }

    @Override
    public String toString() {
        return "GithubRepository{name='" + this.getName() + '\'' + ", cloneUrl='" + this.getCloneUrl() + '\'' + '}';
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getFullName() {
        return this.repository.getFullName();
    }

    @Override
    public boolean hasCloneUrl(String url) {
        if (super.hasCloneUrl(url)) {
            return true;
        }
        return Strings.equalAnyValue(url, this.repository.getGitTransportUrl(), this.repository.gitHttpTransportUrl(), this.repository.getSshUrl(), this.repository.getUrl(), this.repository.getSvnUrl());
    }
}

