/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.model.DtoSupport;
import io.fabric8.updatebot.support.FilterHelpers;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import java.util.ArrayList;
import java.util.List;

public class FilterSupport
extends DtoSupport {
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();

    public void include(String ... values) {
        this.addValues(this.includes, values);
    }

    public void exclude(String ... values) {
        this.addValues(this.excludes, values);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Filter<String> createFilter() {
        Filter includeFilter = Filters.createStringFilters(this.includes);
        if (this.excludes.isEmpty()) {
            if (this.includes.isEmpty()) {
                return Filters.falseFilter();
            }
            return includeFilter;
        }
        Filter excludeFilter = Filters.createStringFilters(this.excludes);
        if (this.includes.isEmpty()) {
            return excludeFilter;
        }
        return FilterHelpers.and(includeFilter, Filters.not((Filter)excludeFilter));
    }

    protected void addValues(List<String> list, String[] values) {
        for (String value : values) {
            if (list.contains(value)) continue;
            list.add(value);
        }
    }
}

