/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.model;

import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.model.MavenArtifactKey;
import io.fabric8.utils.Objects;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DependencyVersionChange {
    private final Kind kind;
    private final String dependency;
    private final String version;
    private final String scope;

    public DependencyVersionChange(Kind kind, String dependency, String version) {
        this(kind, dependency, version, null);
    }

    public DependencyVersionChange(Kind kind, String dependency, String version, String scope) {
        this.kind = kind;
        this.dependency = dependency;
        this.version = version;
        this.scope = scope;
    }

    public static String describe(List<DependencyVersionChange> changes) {
        if (changes.isEmpty()) {
            return "no changes";
        }
        return changes.stream().map(c -> c.getDependency() + " => " + c.getVersion()).collect(Collectors.joining(", "));
    }

    public static boolean hasDependency(List<DependencyVersionChange> changes, DependencyVersionChange change) {
        return changes.stream().anyMatch(c -> c.matches(change));
    }

    public static List<DependencyVersionChange> forKind(Kind kind, List<DependencyVersionChange> list) {
        return list.stream().filter(d -> kind.equals((Object)d.getKind())).collect(Collectors.toList());
    }

    public static Map<Kind, List<DependencyVersionChange>> byKind(List<DependencyVersionChange> list) {
        LinkedHashMap<Kind, List<DependencyVersionChange>> answer = new LinkedHashMap<Kind, List<DependencyVersionChange>>();
        for (DependencyVersionChange change : list) {
            Kind key = change.getKind();
            ArrayList<DependencyVersionChange> changes = (ArrayList<DependencyVersionChange>)answer.get((Object)key);
            if (changes == null) {
                changes = new ArrayList<DependencyVersionChange>();
                answer.put(key, changes);
            }
            changes.add(change);
        }
        return answer;
    }

    public String toString() {
        return "DependencyVersionChange{kind=" + (Object)((Object)this.kind) + ", dependency='" + this.dependency + '\'' + ", version='" + this.version + '\'' + ", scope='" + this.scope + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyVersionChange that = (DependencyVersionChange)o;
        if (this.kind != that.kind) {
            return false;
        }
        if (!this.dependency.equals(that.dependency)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.dependency.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public boolean matches(DependencyVersionChange that) {
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.dependency, (Object)that.dependency);
    }

    public boolean matches(String groupId, String artifactId) {
        return this.matches(new MavenArtifactKey(groupId, artifactId));
    }

    public boolean matches(MavenArtifactKey artifactKey) {
        return Objects.equal((Object)this.dependency, (Object)artifactKey.toString());
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getDependency() {
        return this.dependency;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }
}

