/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.npm.dependency;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.updatebot.kind.npm.NpmDependencyKinds;
import io.fabric8.updatebot.kind.npm.dependency.DependencyCheck;
import io.fabric8.updatebot.kind.npm.dependency.DependencyInfo;
import io.fabric8.updatebot.support.JsonNodes;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DependencyTree {
    private Map<String, DependencyInfo> dependencies = new LinkedHashMap<String, DependencyInfo>();

    public static DependencyTree parseTree(JsonNode tree) {
        DependencyTree dependencyTree = new DependencyTree();
        dependencyTree.parse(tree, null);
        return dependencyTree;
    }

    protected void parse(JsonNode tree, DependencyInfo parent) {
        for (String dependencyKey : NpmDependencyKinds.DEPENDENCY_KEYS) {
            JsonNode deps = tree.get(dependencyKey);
            if (!(deps instanceof ObjectNode)) continue;
            ObjectNode objectNode = (ObjectNode)deps;
            Iterator iter = objectNode.fieldNames();
            while (iter.hasNext()) {
                String field = (String)iter.next();
                JsonNode properties = objectNode.get(field);
                String version = JsonNodes.textValue(properties, "version");
                DependencyInfo dependencyInfo = this.getOrCreateDependencyInfo(field);
                if (parent == null) {
                    dependencyInfo.setVersion(version);
                } else {
                    dependencyInfo.addDependency(parent, version, dependencyKey);
                }
                this.parse(properties, dependencyInfo);
            }
        }
    }

    public DependencyCheck dependencyCheck(String dependency) {
        DependencyInfo info = this.getDependencyInfo(dependency);
        if (info == null) {
            return new DependencyCheck(true, "Not found!", null);
        }
        return info.dependencyCheck();
    }

    protected DependencyInfo getOrCreateDependencyInfo(String dependency) {
        DependencyInfo answer = this.getDependencyInfo(dependency);
        if (answer == null) {
            answer = new DependencyInfo(dependency);
            this.dependencies.put(dependency, answer);
        }
        return answer;
    }

    public DependencyInfo getDependencyInfo(String dependency) {
        return this.dependencies.get(dependency);
    }
}

