/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.npm.dependency;

import io.fabric8.updatebot.kind.npm.dependency.DependencyCheck;
import io.fabric8.updatebot.kind.npm.dependency.DependencyLink;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyInfo {
    private static final transient Logger LOG = LoggerFactory.getLogger(DependencyInfo.class);
    private final String dependency;
    private String version;
    private Map<String, List<DependencyLink>> versions = new TreeMap<String, List<DependencyLink>>();

    public DependencyInfo(String dependency) {
        this.dependency = dependency;
    }

    public String toString() {
        return Strings.notEmpty(this.version) ? this.dependency + "@" + this.version : this.dependency;
    }

    public DependencyCheck dependencyCheck() {
        if (this.versions.isEmpty()) {
            return new DependencyCheck(true, "No transient dependencies of " + this.dependency, this);
        }
        if (this.versions.keySet().size() == 1 && this.versions.containsKey(this.version)) {
            return new DependencyCheck(true, "All transitive dependencies using " + this.version, this);
        }
        return new DependencyCheck(false, "Direct dependency is " + this.version + " but has conflicts: " + this.conflictedDependencyText(), this);
    }

    private String conflictedDependencyText() {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, List<DependencyLink>> entry : this.versions.entrySet()) {
            String key = entry.getKey();
            if (Objects.equal((Object)this.version, (Object)key)) continue;
            List<DependencyLink> dependencies = entry.getValue();
            String dependencyNames = dependencies.stream().map(link -> link.getParent().toString()).collect(Collectors.joining(", "));
            messages.add(dependencyNames + " => " + key);
        }
        return String.join((CharSequence)", ", messages);
    }

    public String getDependency() {
        return this.dependency;
    }

    public Map<String, List<DependencyLink>> getVersions() {
        return this.versions;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addDependency(DependencyInfo parent, String version, String dependencyKey) {
        if (version == null) {
            LOG.debug("Dependency " + parent + " does not specify a version for " + this.dependency);
        } else {
            List<DependencyLink> dependencyLinks = this.versions.get(version);
            if (dependencyLinks == null) {
                dependencyLinks = new ArrayList<DependencyLink>();
                this.versions.put(version, dependencyLinks);
            }
            dependencyLinks.add(new DependencyLink(parent, this, version, dependencyKey));
        }
    }
}

