/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.npm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.PushVersionChangesContext;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.kind.KindDependenciesCheck;
import io.fabric8.updatebot.kind.Updater;
import io.fabric8.updatebot.kind.UpdaterSupport;
import io.fabric8.updatebot.kind.npm.NpmDependencyKinds;
import io.fabric8.updatebot.kind.npm.dependency.DependencyCheck;
import io.fabric8.updatebot.kind.npm.dependency.DependencyTree;
import io.fabric8.updatebot.model.Dependencies;
import io.fabric8.updatebot.model.DependencySet;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.model.NpmDependencies;
import io.fabric8.updatebot.support.FileHelper;
import io.fabric8.updatebot.support.JsonNodes;
import io.fabric8.updatebot.support.MarkupHelper;
import io.fabric8.updatebot.support.ProcessHelper;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Files;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageJsonUpdater
extends UpdaterSupport
implements Updater {
    private static final transient Logger LOG = LoggerFactory.getLogger(PackageJsonUpdater.class);

    @Override
    public boolean isApplicable(CommandContext context) {
        return FileHelper.isFile(context.file("package.json"));
    }

    @Override
    public boolean pushVersions(PushVersionChangesContext context) throws IOException {
        File file = context.file("package.json");
        JsonNode tree = MarkupHelper.loadJson(file);
        boolean answer = false;
        for (String dependencyKey : NpmDependencyKinds.DEPENDENCY_KEYS) {
            ObjectNode objectNode;
            JsonNode dependencies = tree.get(dependencyKey);
            if (!(dependencies instanceof ObjectNode) || !this.doPushVersionChange(dependencyKey, objectNode = (ObjectNode)dependencies, context)) continue;
            answer = true;
        }
        if (answer) {
            MarkupHelper.savePrettyJson(file, tree);
            context.updatedFile(file);
        }
        return answer;
    }

    @Override
    public void addVersionChangesFromSource(CommandContext context, Dependencies dependencyConfig, List<DependencyVersionChange> list) {
        NpmDependencies dependencies = dependencyConfig.getNpm();
        JsonNode tree = this.getPackageJsonTree(context);
        if (tree != null) {
            String name = JsonNodes.textValue(tree, "name");
            String version = JsonNodes.textValue(tree, "version");
            if (Strings.notEmpty(name) && Strings.notEmpty(version)) {
                if (this.isDevelopmentVersion(name, version)) {
                    context.info(LOG, "Not updating NPM dependency " + name + " version " + version + " as this is a development version and not a release");
                } else {
                    list.add(new DependencyVersionChange(Kind.NPM, name, version, "dependencies"));
                }
            }
            if (dependencies != null) {
                this.addUpdateDependencySteps(list, tree, dependencies.getDependencies(), "dependencies");
                this.addUpdateDependencySteps(list, tree, dependencies.getDevDependencies(), "devDependencies");
                this.addUpdateDependencySteps(list, tree, dependencies.getPeerDependencies(), "peerDependencies");
            }
        }
    }

    protected JsonNode getPackageJsonTree(CommandContext context) {
        return this.getJsonFile(context, "package.json");
    }

    protected JsonNode getJsonFile(CommandContext context, String fileName) {
        JsonNode tree = null;
        File file = context.file(fileName);
        if (Files.isFile((File)file)) {
            try {
                tree = MarkupHelper.loadJson(file);
            }
            catch (IOException e) {
                LOG.warn("Failed to parse JSON " + file + ". " + e, (Throwable)e);
            }
        }
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KindDependenciesCheck checkDependencies(CommandContext context, List<DependencyVersionChange> changes) {
        ArrayList<DependencyVersionChange> validChanges = new ArrayList<DependencyVersionChange>();
        ArrayList<DependencyVersionChange> invalidChanges = new ArrayList<DependencyVersionChange>();
        TreeMap<String, DependencyCheck> failedChecks = new TreeMap<String, DependencyCheck>();
        String dependencyFileName = ".dependency-tree.json";
        this.generateDependencyTree(context, dependencyFileName);
        JsonNode json = null;
        try {
            json = this.getJsonFile(context, dependencyFileName);
        }
        finally {
            File file = new File(context.getDir(), dependencyFileName);
            if (Files.isFile((File)file)) {
                file.delete();
            }
        }
        if (json != null) {
            DependencyTree dependencyTree = DependencyTree.parseTree(json);
            for (DependencyVersionChange change : changes) {
                DependencyCheck dependencyCheck = dependencyTree.dependencyCheck(change.getDependency());
                if (dependencyCheck.isValid()) {
                    validChanges.add(change);
                    continue;
                }
                invalidChanges.add(change);
                failedChecks.put(change.getDependency(), dependencyCheck);
            }
        }
        return new KindDependenciesCheck(validChanges, invalidChanges, failedChecks);
    }

    protected void generateDependencyTree(CommandContext context, String dependencyFileName) {
        context.getConfiguration().getNpmDependencyTreeGenerator().generateDependencyTree(context, dependencyFileName);
    }

    protected boolean isDevelopmentVersion(String name, String version) {
        return version.endsWith("-development");
    }

    protected void addUpdateDependencySteps(List<DependencyVersionChange> list, JsonNode tree, DependencySet dependencySet, String dependencyKey) {
        if (dependencySet != null) {
            Filter<String> filter = dependencySet.createFilter();
            JsonNode dependencies = tree.get(dependencyKey);
            if (dependencies instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)dependencies;
                Iterator iter = objectNode.fieldNames();
                while (iter.hasNext()) {
                    String value;
                    String field = (String)iter.next();
                    if (!filter.matches((Object)field) || (value = JsonNodes.textValue((JsonNode)objectNode, field)) == null) continue;
                    list.add(new DependencyVersionChange(Kind.NPM, field, value, dependencyKey));
                }
            }
        }
    }

    @Override
    public boolean pullVersions(CommandContext context) throws IOException {
        File dir = context.getRepository().getDir();
        return ProcessHelper.runCommandAndLogOutput(context.getConfiguration(), LOG, dir, "ncu", "--upgrade");
    }

    protected boolean doPushVersionChange(String dependencyKey, ObjectNode dependencies, PushVersionChangesContext context) {
        String old;
        String name = context.getName();
        String value = context.getValue();
        JsonNode dependency = dependencies.get(name);
        if (dependency != null && dependency.isTextual() && !Objects.equal((Object)(old = dependency.textValue()), (Object)value)) {
            dependencies.put(name, value);
            context.updatedVersion(dependencyKey, name, value, old);
            return true;
        }
        return false;
    }
}

