/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.npm;

import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.kind.npm.NpmDependencyTreeGenerator;
import io.fabric8.updatebot.support.ProcessHelper;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNpmDependencyTreeGenerator
implements NpmDependencyTreeGenerator {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultNpmDependencyTreeGenerator.class);

    @Override
    public void generateDependencyTree(CommandContext context, String dependencyFileName) {
        File dir = context.getDir();
        context.info(LOG, "Generating dependency tree file " + dependencyFileName + " in " + dir);
        ProcessHelper.runCommandIgnoreOutput(dir, "npm", "install");
        File outputFile = new File(dir, dependencyFileName);
        File errorFile = new File(dir, "npm-list-errors.log");
        if (ProcessHelper.runCommand(dir, outputFile, errorFile, "npm", "list", "-json") != 0) {
            context.warn(LOG, "Failed to generate dependencies file " + outputFile);
        } else {
            LOG.debug("Generate dependencies file " + outputFile);
        }
    }
}

