/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.maven;

import de.pdark.decentxml.Document;
import io.fabric8.updatebot.kind.maven.PomHelper;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomUpdateStatus {
    private static final transient Logger LOG = LoggerFactory.getLogger(PomUpdateStatus.class);
    private final File pom;
    private final Document doc;
    private boolean updated;

    public PomUpdateStatus(File pom, Document doc) {
        this.pom = pom;
        this.doc = doc;
    }

    public static PomUpdateStatus createPomUpdateStatus(File file) throws IOException {
        Document doc = PomHelper.parseXmlFile(file);
        return new PomUpdateStatus(file, doc);
    }

    public boolean saveIfChanged() throws IOException {
        if (this.updated) {
            LOG.info("Updating " + this.pom);
            try {
                IOHelpers.writeFully((File)this.pom, (String)this.doc.toXML());
            }
            catch (Exception e) {
                throw new IOException("failed to save " + this.pom + ". " + e, e);
            }
        }
        return this.updated;
    }

    public void updateVersions(List<DependencyVersionChange> changes, Map<String, String> propertyChanges) {
        for (DependencyVersionChange change : changes) {
            String scope = change.getScope();
            if (Objects.equal((Object)"plugin", (Object)scope)) {
                if (!PomHelper.updatePluginVersion(this.doc, change, propertyChanges)) continue;
                this.updated = true;
                continue;
            }
            if (!PomHelper.updateDependencyVersion(this.doc, change, propertyChanges)) continue;
            this.updated = true;
        }
    }

    public void updateProperties(Map<String, String> propertyChanges) {
        if (PomHelper.updateProperties(this.doc, propertyChanges)) {
            this.updated = true;
        }
    }
}

