/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.maven;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import io.fabric8.updatebot.kind.maven.PomUpdateStatus;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(PomHelper.class);

    public static boolean updatePomVersionsInPoms(File dir, List<DependencyVersionChange> changes) throws IOException {
        ArrayList<PomUpdateStatus> pomsToChange = new ArrayList<PomUpdateStatus>();
        PomHelper.addPomFiles(dir, pomsToChange);
        return PomHelper.updatePomVersions(pomsToChange, changes);
    }

    public static boolean updatePomVersions(List<PomUpdateStatus> pomsToChange, List<DependencyVersionChange> changes) throws IOException {
        TreeMap<String, String> propertyChanges = new TreeMap<String, String>();
        for (PomUpdateStatus status : pomsToChange) {
            status.updateVersions(changes, propertyChanges);
        }
        if (!propertyChanges.isEmpty()) {
            for (PomUpdateStatus status : pomsToChange) {
                status.updateProperties(propertyChanges);
            }
        }
        boolean answer = false;
        for (PomUpdateStatus status : pomsToChange) {
            if (!status.saveIfChanged()) continue;
            answer = true;
        }
        return answer;
    }

    protected static void addPomFiles(File file, List<PomUpdateStatus> pomsToChange) {
        File[] files;
        if (file.isFile()) {
            if (file.getName().equals("pom.xml")) {
                try {
                    PomUpdateStatus updateStatus = PomUpdateStatus.createPomUpdateStatus(file);
                    pomsToChange.add(updateStatus);
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse " + file + ". " + e, (Throwable)e);
                }
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                PomHelper.addPomFiles(child, pomsToChange);
            }
        }
    }

    public static boolean updatePluginVersion(Document doc, DependencyVersionChange change, Map<String, String> propertyChanges) {
        Element rootElement = doc.getRootElement();
        List<Element> plugins = PomHelper.findElementsWithName(rootElement, "plugin");
        String newVersion = change.getVersion();
        boolean update = false;
        for (Element element : plugins) {
            String version;
            String artifactId;
            String groupId = PomHelper.firstChildTextContent(element, "groupId");
            if (!change.matches(groupId, artifactId = PomHelper.firstChildTextContent(element, "artifactId")) || !Strings.notEmpty(version = PomHelper.firstChildTextContent(element, "version"))) continue;
            if (version.startsWith("${") && version.endsWith("}")) {
                String versionProperty = version.substring(2, version.length() - 1);
                propertyChanges.put(versionProperty, newVersion);
                continue;
            }
            if (!PomHelper.updateFirstChild(element, "version", newVersion)) continue;
            update = true;
        }
        return update;
    }

    public static boolean updateDependencyVersion(Document doc, DependencyVersionChange change, Map<String, String> propertyChanges) {
        Element rootElement = doc.getRootElement();
        List<Element> dependencies = PomHelper.findElementsWithName(rootElement, "dependency");
        String newVersion = change.getVersion();
        boolean update = false;
        for (Element element : dependencies) {
            String version;
            String artifactId;
            String groupId = PomHelper.firstChildTextContent(element, "groupId");
            if (!change.matches(groupId, artifactId = PomHelper.firstChildTextContent(element, "artifactId")) || !Strings.notEmpty(version = PomHelper.firstChildTextContent(element, "version"))) continue;
            if (version.startsWith("${") && version.endsWith("}")) {
                String versionProperty = version.substring(2, version.length() - 1);
                propertyChanges.put(versionProperty, newVersion);
                continue;
            }
            if (!PomHelper.updateFirstChild(element, "version", newVersion)) continue;
            update = true;
        }
        return update;
    }

    public static List<Element> findElementsWithName(Element rootElement, String elementName) {
        ArrayList<Element> answer = new ArrayList<Element>();
        List children = rootElement.getChildren();
        for (Element child : children) {
            if (Objects.equal((Object)elementName, (Object)child.getName())) {
                answer.add(child);
                continue;
            }
            answer.addAll(PomHelper.findElementsWithName(child, elementName));
        }
        return answer;
    }

    public static String firstChildTextContent(Element element, String elementName) {
        Element child = PomHelper.firstChild(element, elementName);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public static Element firstChild(Element element, String elementName) {
        return element.getChild(elementName);
    }

    public static boolean updateProperties(Document doc, Map<String, String> propertyChanges) {
        Element rootElement = doc.getRootElement();
        boolean update = false;
        Element properties = PomHelper.firstChild(rootElement, "properties");
        if (properties != null) {
            for (Map.Entry<String, String> entry : propertyChanges.entrySet()) {
                String propertyVersion;
                String propertyName = entry.getKey();
                if (!PomHelper.updateFirstChild(properties, propertyName, propertyVersion = entry.getValue())) continue;
                update = true;
            }
        }
        return update;
    }

    public static Document parseXmlFile(File pomFile) throws IOException {
        XMLParser parser = new XMLParser();
        return XMLParser.parse((File)pomFile);
    }

    private static boolean updateFirstChild(Element parentElement, String elementName, String value) {
        String textContent;
        Element element;
        if (!(parentElement == null || (element = PomHelper.firstChild(parentElement, elementName)) == null || (textContent = element.getText()) != null && value.equals(textContent))) {
            element.setText(value);
            return true;
        }
        return false;
    }
}

