/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind.maven;

import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.PushVersionChangesContext;
import io.fabric8.updatebot.kind.KindDependenciesCheck;
import io.fabric8.updatebot.kind.Updater;
import io.fabric8.updatebot.kind.maven.PomHelper;
import io.fabric8.updatebot.model.Dependencies;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.model.MavenArtifactVersionChange;
import io.fabric8.updatebot.model.MavenArtifactVersionChanges;
import io.fabric8.updatebot.support.FileHelper;
import io.fabric8.updatebot.support.MarkupHelper;
import io.fabric8.updatebot.support.ProcessHelper;
import io.fabric8.utils.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUpdater
implements Updater {
    private static final transient Logger LOG = LoggerFactory.getLogger(MavenUpdater.class);
    String updateBotPluginVersion = "1.0-SNAPSHOT";

    public static boolean runCommandAndLogOutput(CommandContext context, String ... commands) {
        return ProcessHelper.runCommandAndLogOutput(context.getConfiguration(), LOG, context.getDir(), commands);
    }

    @Override
    public boolean isApplicable(CommandContext context) {
        return FileHelper.isFile(context.file("pom.xml"));
    }

    @Override
    public void addVersionChangesFromSource(CommandContext context, Dependencies dependencyConfig, List<DependencyVersionChange> list) throws IOException {
        File file = context.file("pom.xml");
        if (Files.isFile((File)file)) {
            String configFile = context.getConfiguration().getConfigFile();
            File versionsFile = this.createVersionsYamlFile(context);
            if (MavenUpdater.runCommandAndLogOutput(context, "mvn", "io.fabric8.updatebot:updatebot-maven-plugin:" + this.updateBotPluginVersion + ":export", "-DdestFile=" + versionsFile, "-DupdateBotYaml=" + configFile)) {
                MavenArtifactVersionChanges changes;
                if (!Files.isFile((File)versionsFile)) {
                    LOG.warn("Should have generated the export versions file " + versionsFile);
                    return;
                }
                try {
                    changes = MarkupHelper.loadYaml(versionsFile, MavenArtifactVersionChanges.class);
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + versionsFile + ". " + e, e);
                }
                List<MavenArtifactVersionChange> changeList = changes.getChanges();
                if (list != null) {
                    for (MavenArtifactVersionChange change : changeList) {
                        list.add(change.createDependencyVersionChange());
                    }
                }
            }
        }
    }

    @Override
    public boolean pushVersions(PushVersionChangesContext context) throws IOException {
        List<DependencyVersionChange> list = Arrays.asList(context.getStep());
        return this.pushVersions(context, list);
    }

    @Override
    public boolean pushVersions(CommandContext context, List<DependencyVersionChange> changes) throws IOException {
        File file = context.file("pom.xml");
        boolean answer = false;
        if (Files.isFile((File)file) && PomHelper.updatePomVersionsInPoms(context.getDir(), changes)) {
            return true;
        }
        return answer;
    }

    protected File createVersionsYamlFile(CommandContext context) {
        return new File(context.getDir(), "target/updatebot-versions.yaml");
    }

    @Override
    public boolean pullVersions(CommandContext context) throws IOException {
        return false;
    }

    @Override
    public KindDependenciesCheck checkDependencies(CommandContext context, List<DependencyVersionChange> value) {
        return new KindDependenciesCheck(value);
    }
}

