/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind;

import io.fabric8.updatebot.kind.npm.dependency.DependencyCheck;
import io.fabric8.updatebot.model.DependencyVersionChange;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KindDependenciesCheck {
    private final List<DependencyVersionChange> validChanges;
    private final List<DependencyVersionChange> invalidChanges;
    private final Map<String, DependencyCheck> failedChecks;

    public KindDependenciesCheck() {
        this.validChanges = new ArrayList<DependencyVersionChange>();
        this.invalidChanges = new ArrayList<DependencyVersionChange>();
        this.failedChecks = new LinkedHashMap<String, DependencyCheck>();
    }

    public KindDependenciesCheck(List<DependencyVersionChange> validChanges) {
        this.validChanges = validChanges;
        this.invalidChanges = new ArrayList<DependencyVersionChange>();
        this.failedChecks = new LinkedHashMap<String, DependencyCheck>();
    }

    public KindDependenciesCheck(List<DependencyVersionChange> validChanges, List<DependencyVersionChange> invalidChanges, Map<String, DependencyCheck> failedChecks) {
        this.validChanges = validChanges;
        this.invalidChanges = invalidChanges;
        this.failedChecks = failedChecks;
    }

    public List<DependencyVersionChange> getValidChanges() {
        return this.validChanges;
    }

    public List<DependencyVersionChange> getInvalidChanges() {
        return this.invalidChanges;
    }

    public Map<String, DependencyCheck> getFailedChecks() {
        return this.failedChecks;
    }

    public void append(KindDependenciesCheck that) {
        this.validChanges.addAll(that.validChanges);
        this.invalidChanges.addAll(that.invalidChanges);
        this.failedChecks.putAll(that.failedChecks);
    }

    public List<DependencyCheck> getFailedChecksFor(List<DependencyVersionChange> changes) {
        HashSet<String> processed = new HashSet<String>();
        ArrayList<DependencyCheck> answer = new ArrayList<DependencyCheck>();
        for (DependencyVersionChange dependencyVersionChange : changes) {
            String dependency = dependencyVersionChange.getDependency();
            DependencyCheck check = this.failedChecks.get(dependency);
            if (check == null) continue;
            processed.add(dependency);
            answer.add(check);
        }
        for (Map.Entry entry : this.failedChecks.entrySet()) {
            if (processed.contains(entry.getKey())) continue;
            answer.add((DependencyCheck)entry.getValue());
        }
        return answer;
    }
}

