/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.kind;

import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.PushVersionChangesContext;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.kind.KindDependenciesCheck;
import io.fabric8.updatebot.kind.Updater;
import io.fabric8.updatebot.model.Dependencies;
import io.fabric8.updatebot.model.DependencyVersionChange;
import java.io.IOException;
import java.util.List;

public class CompositeUpdater
implements Updater {
    @Override
    public boolean isApplicable(CommandContext context) {
        return true;
    }

    @Override
    public boolean pushVersions(PushVersionChangesContext context) throws IOException {
        Kind[] kinds = Kind.values();
        boolean answer = false;
        for (Kind kind : kinds) {
            Updater updater = kind.getUpdater();
            if (!updater.isApplicable(context) || !updater.pushVersions(context)) continue;
            answer = true;
        }
        return answer;
    }

    @Override
    public boolean pushVersions(CommandContext context, List<DependencyVersionChange> changes) throws IOException {
        Kind[] kinds = Kind.values();
        boolean answer = false;
        for (Kind kind : kinds) {
            Updater updater = kind.getUpdater();
            if (!updater.isApplicable(context) || !updater.pushVersions(context, changes)) continue;
            answer = true;
        }
        return answer;
    }

    @Override
    public boolean pullVersions(CommandContext context) throws IOException {
        Kind[] kinds = Kind.values();
        boolean answer = false;
        for (Kind kind : kinds) {
            Updater updater = kind.getUpdater();
            if (!updater.isApplicable(context) || !updater.pullVersions(context)) continue;
            answer = true;
        }
        return answer;
    }

    @Override
    public void addVersionChangesFromSource(CommandContext context, Dependencies dependencyConfig, List<DependencyVersionChange> list) throws IOException {
        Kind[] kinds;
        for (Kind kind : kinds = Kind.values()) {
            Updater updater = kind.getUpdater();
            if (!updater.isApplicable(context)) continue;
            updater.addVersionChangesFromSource(context, dependencyConfig, list);
        }
    }

    @Override
    public KindDependenciesCheck checkDependencies(CommandContext context, List<DependencyVersionChange> changes) {
        Kind[] kinds;
        KindDependenciesCheck answer = new KindDependenciesCheck();
        for (Kind kind : kinds = Kind.values()) {
            Updater updater = kind.getUpdater();
            if (!updater.isApplicable(context)) continue;
            KindDependenciesCheck result = updater.checkDependencies(context, changes);
            answer.append(result);
        }
        return answer;
    }
}

