/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.github;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.github.Issues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequests {
    public static final String COMMAND_COMMENT_PREFIX = "[UpdateBot](https://github.com/fabric8io/updatebot) commands:";
    public static final String COMMAND_COMMENT_PREFIX_SEPARATOR = "\n\n";
    public static final String COMMAND_COMMENT_INDENT = "    updatebot ";
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequests.class);
    public static String ISSUE_LINK_COMMENT = "[UpdateBot](https://github.com/fabric8io/updatebot) raised issue ";
    public static String ISSUE_LINK_COMMENT_SUFFIX = " to manage version conflicts";

    public static List<GHPullRequest> getOpenPullRequests(GHRepository ghRepository, Configuration configuration) throws IOException {
        return PullRequests.getOpenPullRequests(ghRepository, configuration.getGithubPullRequestLabel());
    }

    public static List<GHPullRequest> getOpenPullRequests(GHRepository ghRepository, String label) throws IOException {
        List pullRequests = GitHubHelpers.retryGithub(() -> ghRepository.getPullRequests(GHIssueState.OPEN));
        ArrayList<GHPullRequest> answer = new ArrayList<GHPullRequest>();
        if (pullRequests != null) {
            for (GHPullRequest pullRequest : pullRequests) {
                if (!GitHubHelpers.hasLabel(Issues.getLabels((GHIssue)pullRequest), label)) continue;
                answer.add(pullRequest);
            }
        }
        return answer;
    }

    public static void logOpen(List<GHPullRequest> prs) {
        for (GHPullRequest pr : prs) {
            LOG.info("Open Pull Request " + pr.getHtmlUrl());
        }
    }
}

