/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.github;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.kind.DependenciesCheck;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.kind.KindDependenciesCheck;
import io.fabric8.updatebot.kind.npm.dependency.DependencyCheck;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Issues {
    public static final String BODY = "[UpdateBot](https://github.com/fabric8io/updatebot) cannot update some dependency versions until other projects are released to fix dependency conflicts.\n\nThis issue is used to coordinate version changes on this repository coming from other repositories and will be closed once all the version conflicts are resolved.";
    public static final String CLOSE_MESSAGE = "[UpdateBot](https://github.com/fabric8io/updatebot) closing as no more dependency conflicts while ";
    public static final String PENDING_CHANGE_COMMENT_PREFIX = "[UpdateBot](https://github.com/fabric8io/updatebot) detected conflicts while ";
    public static final String HEADER_KIND = "## ";
    public static final String CONFLICTS_HEADER = "### Conflicts";
    public static final String CONFLICT_PREFIX = "* ";
    public static final String PENDING_COMMAND_PREFIX = "    ";
    private static final transient Logger LOG = LoggerFactory.getLogger(Issues.class);

    public static List<GHIssue> getOpenIssues(GHRepository ghRepository, Configuration configuration) throws IOException {
        String label = configuration.getGithubPullRequestLabel();
        return Issues.getOpenIssues(ghRepository, label);
    }

    public static List<GHIssue> getOpenIssues(GHRepository ghRepository, String label) throws IOException {
        List issues = GitHubHelpers.retryGithub(() -> ghRepository.getIssues(GHIssueState.OPEN));
        ArrayList<GHIssue> answer = new ArrayList<GHIssue>();
        for (GHIssue issue : issues) {
            if (!GitHubHelpers.hasLabel(Issues.getLabels(issue), label) || issue.isPullRequest()) continue;
            answer.add(issue);
        }
        return answer;
    }

    public static List<DependencyVersionChange> loadPendingChangesFromIssue(CommandContext context, GHIssue issue) throws IOException {
        List comments = issue.getComments();
        String lastCommand = null;
        for (GHIssueComment comment : comments) {
            String command = Issues.updateBotIssuePendingChangesComment(context, comment);
            if (command == null) continue;
            lastCommand = command;
        }
        if (lastCommand == null) {
            LOG.warn("No UpdateBot comment found on issue " + issue.getHtmlUrl());
            return new ArrayList<DependencyVersionChange>();
        }
        return Issues.parseUpdateBotIssuePendingChangesComment(lastCommand);
    }

    public static List<DependencyVersionChange> parseUpdateBotIssuePendingChangesComment(String command) {
        String[] lines = command.split("\n");
        ArrayList<DependencyVersionChange> answer = new ArrayList<DependencyVersionChange>();
        Kind kind = null;
        for (String line : lines) {
            boolean commandLine = line.startsWith(PENDING_COMMAND_PREFIX);
            String text = line.trim();
            if (!Strings.notEmpty(text)) continue;
            if (text.startsWith("#")) {
                String header = Strings.trimAllPrefix(text, "#").trim();
                Kind k = Kind.fromName(header);
                if (k == null) continue;
                kind = k;
                continue;
            }
            if (!commandLine || kind == null) continue;
            Issues.addChangeFromCommentLine(answer, kind, text);
        }
        return answer;
    }

    protected static void addChangeFromCommentLine(List<DependencyVersionChange> answer, Kind kind, String text) {
        String[] words = text.split("\\s+");
        if (words.length < 2) {
            LOG.warn("Ignoring command: Not enough arguments: " + text);
            return;
        }
        String dependency = words[0];
        String version = words[1];
        String scope = null;
        if (words.length > 2) {
            scope = words[2];
        }
        DependencyVersionChange change = scope == null ? new DependencyVersionChange(kind, dependency, version) : new DependencyVersionChange(kind, dependency, version, scope);
        answer.add(change);
    }

    protected static String createPendingVersionChangeCommands(List<DependencyVersionChange> changes) {
        StringBuilder builder = new StringBuilder();
        for (DependencyVersionChange change : changes) {
            builder.append("\n    ");
            String scope = change.getScope();
            if (scope == null) {
                scope = "";
            }
            builder.append(String.join((CharSequence)" ", change.getDependency(), change.getVersion(), scope));
        }
        return builder.toString();
    }

    public static void addConflictsComment(GHIssue issue, List<DependencyVersionChange> pendingChanges, String operationDescription, DependenciesCheck check) throws IOException {
        String prefix = PENDING_CHANGE_COMMENT_PREFIX + operationDescription + "\n";
        String issueComment = prefix + Issues.conflictChangesComment(pendingChanges, check);
        issue.comment(issueComment);
    }

    public static String conflictChangesComment(List<DependencyVersionChange> pendingChanges, DependenciesCheck check) {
        StringBuilder builder = new StringBuilder();
        Map<Kind, KindDependenciesCheck> failures = check.getFailures();
        for (Map.Entry<Kind, KindDependenciesCheck> entry : failures.entrySet()) {
            boolean hasChanges;
            List<DependencyVersionChange> kindChanges;
            Kind kind = entry.getKey();
            KindDependenciesCheck kindCheck = entry.getValue();
            List<DependencyCheck> kindConflicts = kindCheck.getFailedChecksFor(kindChanges = DependencyVersionChange.forKind(kind, pendingChanges));
            boolean hasConflicts = kindConflicts.size() > 0;
            boolean bl = hasChanges = kindChanges.size() > 0;
            if (!hasConflicts || !hasChanges) continue;
            builder.append("\n\n");
            builder.append(HEADER_KIND);
            builder.append(kind.getName());
            if (hasChanges) {
                builder.append("\n");
                builder.append(Issues.createPendingVersionChangeCommands(kindChanges));
            }
            if (!hasConflicts) continue;
            builder.append("\n\n");
            builder.append(CONFLICTS_HEADER);
            builder.append("\n\n");
            builder.append(Issues.createConflictComments(kindConflicts));
        }
        return builder.toString();
    }

    private static String createConflictComments(List<DependencyCheck> conflicts) {
        StringBuilder builder = new StringBuilder();
        for (DependencyCheck conflict : conflicts) {
            if (conflict.isValid()) continue;
            String message = conflict.getMessage();
            String dependency = conflict.getDependency();
            builder.append("* `" + dependency + "` " + message + "\n");
        }
        return builder.toString();
    }

    protected static String createConfictIssueComment(DependenciesCheck check) {
        return null;
    }

    public static String updateBotIssuePendingChangesComment(CommandContext context, GHIssueComment comment) throws IOException {
        String body;
        GHUser user = comment.getUser();
        if (user != null && Objects.equal((Object)context.getConfiguration().getGithubUsername(), (Object)user.getLogin()) && (body = comment.getBody()) != null && (body = body.trim()).startsWith(PENDING_CHANGE_COMMENT_PREFIX)) {
            return body;
        }
        return null;
    }

    public static GHIssue findIssue(CommandContext context, List<GHIssue> issues) {
        String prefix = context.createIssueTitlePrefix();
        if (issues != null) {
            for (GHIssue issue : issues) {
                String title = issue.getTitle();
                if (title == null || !title.startsWith(prefix)) continue;
                return issue;
            }
        }
        return null;
    }

    public static GHIssue createIssue(CommandContext context, GHRepository repository) throws IOException {
        return repository.createIssue(context.createIssueTitlePrefix()).body(BODY).label(context.getConfiguration().getGithubPullRequestLabel()).create();
    }

    public static void logOpen(List<GHIssue> issues) {
        for (GHIssue issue : issues) {
            LOG.info("Open issue " + issue.getHtmlUrl());
        }
    }

    public static Collection<GHLabel> getLabels(GHIssue issue) throws IOException {
        return GitHubHelpers.retryGithub(() -> issue.getLabels());
    }

    public static boolean isOpen(GHIssue issue) {
        GHIssueState state = issue.getState();
        if (state == null) {
            return true;
        }
        return state == GHIssueState.OPEN;
    }
}

