/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.github;

import io.fabric8.updatebot.github.Issues;
import io.fabric8.updatebot.github.PullRequests;
import io.fabric8.updatebot.model.GitRepository;
import io.fabric8.updatebot.model.GithubRepository;
import io.fabric8.updatebot.repository.LocalRepository;
import io.fabric8.utils.Objects;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubHelpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitHubHelpers.class);

    public static void closeOpenUpdateBotIssuesAndPullRequests(String prLabel, List<LocalRepository> repositories) {
        for (LocalRepository repository : repositories) {
            GHRepository ghRepo = GitHubHelpers.getGitHubRepository(repository);
            if (ghRepo == null) continue;
            try {
                GitHubHelpers.closePullRequests(PullRequests.getOpenPullRequests(ghRepo, prLabel));
                GitHubHelpers.closeIssues(Issues.getOpenIssues(ghRepo, prLabel));
            }
            catch (IOException e) {
                LOG.warn("Failed to close pending open Pull Requests on " + repository.getCloneUrl());
            }
        }
    }

    public static void closeIssues(List<GHIssue> issues) throws IOException {
        for (GHIssue issue : issues) {
            issue.close();
        }
    }

    public static void closePullRequests(List<GHPullRequest> pullRequests) throws IOException {
        for (GHPullRequest pullRequest : pullRequests) {
            pullRequest.close();
        }
    }

    public static GHRepository getGitHubRepository(LocalRepository repository) {
        GitRepository repo = repository.getRepo();
        if (repo instanceof GithubRepository) {
            GithubRepository githubRepository = (GithubRepository)repo;
            return githubRepository.getRepository();
        }
        return null;
    }

    public static boolean hasLabel(Collection<GHLabel> labels, String label) {
        if (labels != null) {
            for (GHLabel ghLabel : labels) {
                if (!Objects.equal((Object)label, (Object)ghLabel.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMergeable(GHPullRequest pullRequest) throws IOException {
        boolean canMerge = false;
        Boolean mergeable = pullRequest.getMergeable();
        GHPullRequest single = null;
        if (mergeable == null) {
            single = pullRequest.getRepository().getPullRequest(pullRequest.getNumber());
            mergeable = single.getMergeable();
        }
        if (mergeable == null) {
            LOG.warn("Mergable flag is still null on pull request " + pullRequest.getHtmlUrl() + " assuming its still mergable. Probably a caching issue and this flag may appear again later");
            return true;
        }
        if (mergeable != null && mergeable.booleanValue()) {
            canMerge = true;
        }
        return canMerge;
    }

    public static void deleteUpdateBotBranches(List<LocalRepository> localRepositories) throws IOException {
    }

    public static GHPerson getOrganisationOrUser(GitHub github, String orgName) {
        GHOrganization person = null;
        try {
            person = github.getOrganization(orgName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (person == null) {
            try {
                person = github.getUser(orgName);
            }
            catch (IOException e) {
                LOG.warn("Could not find organisation or user for " + orgName + ". " + e, (Throwable)e);
            }
        }
        return person;
    }

    public static GHCommitStatus getLastCommitStatus(GHRepository repository, GHPullRequest pullRequest) throws IOException {
        String commitSha = pullRequest.getHead().getRef();
        return repository.getLastCommitStatus(commitSha);
    }

    public static <T> T retryGithub(Callable<T> callable) throws IOException {
        return GitHubHelpers.retryGithub(callable, 5, 1000L);
    }

    public static <T> T retryGithub(Callable<T> callable, int retries, long timeout) throws IOException {
        for (int i = 0; i < retries; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                return callable.call();
            }
            catch (HttpException e) {
                int code = e.getResponseCode();
                LOG.warn("GitHub Operation returned response " + code + " so retrying. Exception " + (Object)((Object)e), (Throwable)e);
                if (code < 100) continue;
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public static Boolean waitForPullRequestToHaveMergable(GHPullRequest pullRequest, long sleepMS, long maximumTimeMS) throws IOException {
        long end = System.currentTimeMillis() + maximumTimeMS;
        while (true) {
            Boolean mergeable;
            if ((mergeable = pullRequest.getMergeable()) == null) {
                GHRepository repository = pullRequest.getRepository();
                int number = pullRequest.getNumber();
                pullRequest = repository.getPullRequest(number);
                mergeable = pullRequest.getMergeable();
            }
            if (mergeable != null) {
                return mergeable;
            }
            if (System.currentTimeMillis() > end) {
                return null;
            }
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

