/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.git;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.git.GitPlugin;
import io.fabric8.updatebot.support.ProcessHelper;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPluginCLI
implements GitPlugin {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitPluginCLI.class);
    private final Configuration configuration;

    public GitPluginCLI(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setRemoteURL(File dir, String remoteURL) {
        if (ProcessHelper.runCommandIgnoreOutput(dir, "git", "remote", "set-url", "origin", remoteURL) != 0) {
            this.configuration.warn(LOG, "Could not set the remote URL of " + remoteURL);
        }
    }

    @Override
    public boolean push(File dir, String localBranch) {
        return ProcessHelper.runCommandAndLogOutput(this.configuration, LOG, dir, "git", "push", "-f", "origin", localBranch);
    }

    @Override
    public void pull(File dir, String cloneUrl) {
        LOG.debug("Pulling: " + dir + " repo: " + cloneUrl);
        ProcessHelper.runCommandAndLogOutput(this.configuration, LOG, dir, "git", "pull");
    }

    @Override
    public void clone(File dir, String cloneUrl, String name) {
        ProcessHelper.runCommandAndLogOutput(this.configuration, LOG, dir, "git", "clone", cloneUrl, name);
    }

    @Override
    public boolean commitToBranch(File dir, String branch, String commitComment) {
        if (ProcessHelper.runCommandIgnoreOutput(dir, "git", "checkout", "-b", branch) == 0) {
            return this.addAndCommit(dir, commitComment);
        }
        return false;
    }

    @Override
    public void deleteBranch(File dir, String localBranch) {
        ProcessHelper.runCommandIgnoreOutput(dir, "git", "branch", "-D", localBranch);
    }

    @Override
    public boolean addAndCommit(File dir, String commitComment) {
        return ProcessHelper.runCommandIgnoreOutput(dir, "git", "add", "*") == 0 && ProcessHelper.runCommand(dir, "git", "commit", "-m", commitComment) == 0;
    }

    @Override
    public boolean stashAndCheckoutMaster(File dir) {
        if (ProcessHelper.runCommandIgnoreOutput(dir, "git", "stash") == 0 && ProcessHelper.runCommandIgnoreOutput(dir, "git", "checkout", "master") == 0) {
            return true;
        }
        LOG.warn("Failed to checkout master in " + dir);
        return false;
    }

    @Override
    public void revertChanges(File dir) throws IOException {
        if (ProcessHelper.runCommandIgnoreOutput(dir, "git", "stash") != 0) {
            throw new IOException("Failed to stash old changes!");
        }
    }
}

