/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.git;

import io.fabric8.updatebot.support.ProcessHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;

public interface GitPlugin {
    public static boolean hasChangedFiles(File dir) {
        try {
            String output = ProcessHelper.runCommandCaptureOutput(dir, "git", "status", "-s");
            if (output != null) {
                output = output.trim();
            }
            return Strings.notEmpty((String)output);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setRemoteURL(File var1, String var2);

    public boolean push(File var1, String var2);

    public void pull(File var1, String var2);

    public void clone(File var1, String var2, String var3);

    public boolean commitToBranch(File var1, String var2, String var3);

    public void deleteBranch(File var1, String var2);

    public boolean addAndCommit(File var1, String var2);

    public boolean stashAndCheckoutMaster(File var1);

    public void revertChanges(File var1) throws IOException;
}

