/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.UpdateBot;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.CommandSupport;
import io.fabric8.updatebot.commands.CompositeCommand;
import io.fabric8.updatebot.commands.Status;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.github.Issues;
import io.fabric8.updatebot.github.PullRequests;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.io.IOException;
import java.util.List;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"update"}, commandDescription="Updates open Pull Requests. Rebases any unmergable PRs or merge any PRs that are ready.")
public class UpdatePullRequests
extends CommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(UpdatePullRequests.class);
    @Parameter(names={"--merge"}, description="Whether we should merge Pull Requests that are Open and have a successful last commit status", arity=1)
    private boolean mergeOnSuccess = true;

    @Override
    public void run(CommandContext context) throws IOException {
        Status contextStatus = Status.COMPLETE;
        GHRepository ghRepository = context.gitHubRepository();
        if (ghRepository != null) {
            GHIssue issue = this.getOrFindIssue(context, ghRepository);
            if (issue != null && Issues.isOpen(issue)) {
                contextStatus = Status.PENDING;
            }
            List<GHPullRequest> pullRequests = PullRequests.getOpenPullRequests(ghRepository, context.getConfiguration());
            for (GHPullRequest pullRequest : pullRequests) {
                CompositeCommand commands;
                Configuration configuration = context.getConfiguration();
                if (!GitHubHelpers.hasLabel(Issues.getLabels((GHIssue)pullRequest), configuration.getGithubPullRequestLabel())) continue;
                context.setPullRequest(pullRequest);
                if (!GitHubHelpers.isMergeable(pullRequest) && (commands = this.loadCommandsFromPullRequest(context, ghRepository, pullRequest)) != null) {
                    commands.run(context, ghRepository, pullRequest);
                }
                if (this.mergeOnSuccess) {
                    try {
                        GHCommitState state;
                        GHCommitStatus status = GitHubHelpers.getLastCommitStatus(ghRepository, pullRequest);
                        if (status != null && (state = status.getState()) != null && state.equals((Object)GHCommitState.SUCCESS)) {
                            String message = "[UpdateBot](https://github.com/fabric8io/updatebot) merging this pull request as its CI was successful";
                            pullRequest.merge(message);
                        }
                    }
                    catch (IOException e) {
                        context.warn(LOG, "Failed to find last commit status for PR " + pullRequest.getHtmlUrl() + " " + e, e);
                    }
                }
                if (!Issues.isOpen((GHIssue)pullRequest)) continue;
                contextStatus = Status.PENDING;
            }
        }
        context.setStatus(contextStatus);
    }

    protected CompositeCommand loadCommandsFromPullRequest(CommandContext context, GHRepository ghRepository, GHPullRequest pullRequest) throws IOException {
        List comments = pullRequest.getComments();
        String lastCommand = null;
        for (GHIssueComment comment : comments) {
            String command = this.updateBotCommentCommand(context, comment);
            if (command == null) continue;
            lastCommand = command;
        }
        if (lastCommand == null) {
            context.warn(LOG, "No UpdateBot comment found on pull request " + pullRequest.getHtmlUrl() + " so cannot rebase!");
            return null;
        }
        return this.parseUpdateBotCommandComment(context, lastCommand);
    }

    public CompositeCommand parseUpdateBotCommandComment(CommandContext context, String fullCommand) {
        String[] lines;
        CompositeCommand commands = new CompositeCommand();
        CommandContext answer = new CommandContext(context.getRepository(), context.getConfiguration());
        String command = fullCommand.substring("[UpdateBot](https://github.com/fabric8io/updatebot) commands:".length()).trim();
        for (String line : lines = command.split("\n")) {
            String text = line.trim();
            if (!Strings.notEmpty(text)) continue;
            this.addBotCommand(commands, answer, text);
        }
        return commands;
    }

    private void addBotCommand(CompositeCommand commands, CommandContext context, String commandLine) {
        Configuration dummyConfig;
        String[] args;
        CommandSupport command;
        String subCommand = commandLine;
        if (subCommand.startsWith("updatebot")) {
            subCommand = subCommand.substring("updatebot".length()).trim();
        }
        if ((command = UpdateBot.parseCommand(args = subCommand.split(" "), dummyConfig = new Configuration(), false)) == null) {
            context.warn(LOG, "Could not parse command line: " + commandLine);
        } else {
            commands.addCommand(command);
        }
    }

    private String updateBotCommentCommand(CommandContext context, GHIssueComment comment) throws IOException {
        String body;
        GHUser user = comment.getUser();
        if (user != null && Objects.equal((Object)context.getConfiguration().getGithubUsername(), (Object)user.getLogin()) && (body = comment.getBody()) != null && (body = body.trim()).startsWith("[UpdateBot](https://github.com/fabric8io/updatebot) commands:")) {
            return body;
        }
        return null;
    }
}

