/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.utils.Objects;
import java.util.ArrayList;
import java.util.List;

public class PushVersionChangesContext
extends CommandContext {
    private final DependencyVersionChange step;
    private List<Change> changes = new ArrayList<Change>();

    public PushVersionChangesContext(CommandContext parentContext, DependencyVersionChange step) {
        super(parentContext);
        this.step = step;
    }

    public String toString() {
        return "PushVersionContext{kind='" + (Object)((Object)this.getKind()) + '\'' + ", name='" + this.getName() + '\'' + ", value='" + this.getValue() + '\'' + '}';
    }

    @Override
    public String createPullRequestBody() {
        return "[UpdateBot](https://github.com/fabric8io/updatebot) pushed " + (Object)((Object)this.step.getKind()) + " dependency: `" + this.step.getDependency() + "` to: `" + this.step.getVersion() + "`";
    }

    @Override
    public String createCommit() {
        return "fix(version): update " + this.step.getDependency() + " to " + this.step.getVersion();
    }

    @Override
    public String createPullRequestTitle() {
        return this.createPullRequestTitlePrefix() + this.step.getVersion();
    }

    @Override
    public String createPullRequestTitlePrefix() {
        return "update " + this.step.getDependency() + " to ";
    }

    public DependencyVersionChange getStep() {
        return this.step;
    }

    public Kind getKind() {
        return this.step.getKind();
    }

    public String getName() {
        return this.step.getDependency();
    }

    public String getValue() {
        return this.step.getVersion();
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public void updatedVersion(String dependencyKey, String name, String newValue, String oldValue) {
        this.changes.add(new Change(dependencyKey, name, newValue, oldValue));
    }

    public Change change(String name) {
        for (Change change : this.changes) {
            if (!Objects.equal((Object)name, (Object)change.getName())) continue;
            return change;
        }
        return null;
    }

    public static class Change {
        private final String scope;
        private final String name;
        private final String newValue;
        private final String oldValue;

        public Change(String scope, String name, String newValue, String oldValue) {
            this.scope = scope;
            this.name = name;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public String toString() {
            return "Change{scope='" + this.scope + '\'' + ", name='" + this.name + '\'' + ", newValue='" + this.newValue + '\'' + ", oldValue='" + this.oldValue + '\'' + '}';
        }

        public String getScope() {
            return this.scope;
        }

        public String getName() {
            return this.name;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }
}

