/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.ModifyFilesCommandSupport;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.repository.LocalRepository;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"push-version"}, commandDescription="Pushes version changes into your projects. You usually invoke this command after a release has been performed")
public class PushVersionChanges
extends ModifyFilesCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(PushVersionChanges.class);
    @Parameter(order=0, names={"--kind", "-k"}, description="The kind of property to replace based on the kind of language or build tool.", required=true)
    private Kind kind;
    @Parameter(description="The property name and values to be replaced", required=true)
    private List<String> values;

    public PushVersionChanges() {
    }

    public PushVersionChanges(Kind kind, List<String> values) {
        this.kind = kind;
        this.values = values;
    }

    public PushVersionChanges(Kind kind, String ... values) {
        this(kind, Arrays.asList(values));
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
        if (values.isEmpty()) {
            throw new ParameterException("At least 2 values need to be specified for the property to be updated and its value!");
        }
        if (values.size() % 2 == 1) {
            throw new ParameterException("You must specify an even number of arguments for pairs of the property and version!");
        }
    }

    public void values(String ... values) {
        this.setValues(Arrays.asList(values));
    }

    @Override
    protected boolean doProcess(CommandContext context) throws IOException {
        LocalRepository repository = context.getRepository();
        File dir = repository.getDir();
        LOG.debug("Updating version in: " + dir + " repo: " + repository.getCloneUrl());
        boolean answer = false;
        int i = 0;
        while (i + 1 < this.values.size()) {
            String propertyName = this.values.get(i);
            String version = this.values.get(i + 1);
            DependencyVersionChange step = new DependencyVersionChange(Kind.NPM, propertyName, version);
            if (this.pushVersionsWithChecks(context, Arrays.asList(step))) {
                answer = true;
            }
            i += 2;
        }
        return answer;
    }
}

