/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.PushSourceChanges;
import io.fabric8.updatebot.repository.LocalRepository;

public class PushSourceChangesContext
extends CommandContext {
    private final PushSourceChanges command;
    private final LocalRepository sourceRepository;

    public PushSourceChangesContext(LocalRepository repository, Configuration configuration, PushSourceChanges command, LocalRepository sourceRepository) {
        super(repository, configuration);
        this.command = command;
        this.sourceRepository = sourceRepository;
    }

    public PushSourceChangesContext(CommandContext parentContext, PushSourceChanges command, LocalRepository sourceRepository) {
        super(parentContext);
        this.command = command;
        this.sourceRepository = sourceRepository;
    }

    public PushSourceChanges getCommand() {
        return this.command;
    }

    @Override
    public String createPullRequestBody() {
        String gitUrl = this.command.getCloneUrl();
        String ref = this.command.getRef();
        String linkText = LocalRepository.getRepositoryLink(this.sourceRepository, gitUrl);
        return "[UpdateBot](https://github.com/fabric8io/updatebot) pushed version changes from the source code in repository: " + linkText + " ref: `" + ref + "`\n";
    }

    @Override
    public String createCommit() {
        String gitUrl = this.command.getCloneUrl();
        String ref = this.command.getRef();
        return "fix(versions): " + gitUrl + "\n\nPush version changes from the source code in repository: " + gitUrl + " ref: " + ref + "\n";
    }

    @Override
    public String createPullRequestTitle() {
        return this.createPullRequestTitlePrefix() + this.command.getRef();
    }

    @Override
    public String createPullRequestTitlePrefix() {
        return "push " + this.command.getCloneUrl() + " ";
    }
}

