/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.ModifyFilesCommandSupport;
import io.fabric8.updatebot.commands.PushSourceChangesContext;
import io.fabric8.updatebot.kind.CompositeUpdater;
import io.fabric8.updatebot.model.Dependencies;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.model.GitRepository;
import io.fabric8.updatebot.model.GitRepositoryConfig;
import io.fabric8.updatebot.repository.LocalRepository;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Files;
import io.fabric8.utils.GitHelpers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"push"}, commandDescription="Pushes version and dependency changes from your local source code into downstream projects. You usually invoke this command after a release has been performed using the tagged versioned code as the input")
public class PushSourceChanges
extends ModifyFilesCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(PushSourceChanges.class);
    @Parameter(names={"--ref", "-r"}, description="The git repository ref (sha, branch or tag) to clone the source repository from for the source code")
    private String ref = "master";
    @Parameter(description="The git repository to clone from for the source code")
    private String cloneUrl;
    private LocalRepository sourceRepository;

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getCloneUrl() {
        return this.cloneUrl;
    }

    public void setCloneUrl(String cloneUrl) {
        this.cloneUrl = cloneUrl;
    }

    @Override
    protected String getOperationDescription(CommandContext context) {
        LocalRepository sourceRepository = this.getSourceRepository();
        if (sourceRepository != null) {
            return "pushing versions from " + LocalRepository.getRepositoryLink(sourceRepository);
        }
        return super.getOperationDescription(context);
    }

    @Override
    protected boolean doProcess(CommandContext context) throws IOException {
        LocalRepository repository = context.getRepository();
        if (repository.hasCloneUrl(this.cloneUrl)) {
            LOG.debug("Ignoring repository " + repository.getCloneUrl() + " as this is the source repository!");
            return false;
        }
        List<DependencyVersionChange> steps = this.loadVersionChangesFromSource(context);
        String sourceFullName = this.getCloneUrl();
        LocalRepository sourceRepository = this.getSourceRepository();
        if (sourceRepository != null) {
            sourceFullName = sourceRepository.getFullName();
        }
        String message = "push source changes from " + sourceFullName + " to " + context.getRepositoryFullName();
        String stepDescription = " changes found: " + DependencyVersionChange.describe(steps);
        if (steps.isEmpty()) {
            stepDescription = " no changes found";
            LOG.debug(message + stepDescription);
        } else {
            context.info(LOG, message + stepDescription);
        }
        return this.pushVersionsWithChecks(context, steps);
    }

    @Override
    protected void validateConfiguration(Configuration configuration) throws IOException {
        File sourceDir;
        File dir = configuration.getSourceDir();
        if (this.cloneUrl == null && dir != null) {
            String url;
            if (!Files.isDirectory((File)dir)) {
                throw new ParameterException("Directory does not exist " + dir);
            }
            try {
                url = GitHelpers.extractGitUrl((File)dir);
            }
            catch (IOException e) {
                throw new ParameterException("Could not find the git clone URL in " + dir + ". " + e, (Throwable)e);
            }
            if (url != null) {
                this.setCloneUrl(url);
            }
        }
        this.validateCloneUrl();
        if (this.sourceRepository == null) {
            this.sourceRepository = this.findLocalRepository(configuration);
        }
        if (this.sourceRepository == null && (sourceDir = configuration.getSourceDir()) != null) {
            GitRepository repo = new GitRepository(dir.getName());
            repo.setCloneUrl(this.getCloneUrl());
            this.sourceRepository = new LocalRepository(repo, dir);
        }
        if (dir != null) {
            configuration.setSourceDir(dir);
        }
    }

    @Override
    protected CommandContext createCommandContext(LocalRepository repository, Configuration configuration) {
        return new PushSourceChangesContext(repository, configuration, this, this.getSourceRepository());
    }

    public LocalRepository getSourceRepository() {
        return this.sourceRepository;
    }

    protected List<DependencyVersionChange> loadVersionChangesFromSource(CommandContext context) throws IOException {
        Configuration configuration = context.getConfiguration();
        ArrayList<DependencyVersionChange> list = new ArrayList<DependencyVersionChange>();
        if (this.sourceRepository == null) {
            context.warn(LOG, "No source repository for " + context.getDir());
            return list;
        }
        GitRepository repo = this.sourceRepository.getRepo();
        if (repo == null) {
            context.warn(LOG, "No git repo for " + this.sourceRepository + " " + context.getDir());
            return list;
        }
        GitRepositoryConfig repositoryDetails = repo.getRepositoryDetails();
        Dependencies push = null;
        if (repositoryDetails == null) {
            LOG.debug("No push repository details found for repository " + this.sourceRepository);
        } else {
            push = repositoryDetails.getPush();
        }
        if (push == null) {
            LOG.debug("No push version details found for repository " + this.sourceRepository + " for configuration " + repositoryDetails);
            push = new Dependencies();
        }
        CommandContext sourceContext = new CommandContext(this.sourceRepository, configuration);
        CompositeUpdater updater = new CompositeUpdater();
        updater.addVersionChangesFromSource(sourceContext, push, list);
        return list;
    }

    protected void validateCloneUrl() {
        String cloneUrl = this.getCloneUrl();
        if (Strings.empty(cloneUrl)) {
            throw new IllegalArgumentException("No cloneUrl argument specified!");
        }
    }

    protected LocalRepository findLocalRepository(Configuration configuration) throws IOException {
        String cloneUrl = this.getCloneUrl();
        List<LocalRepository> localRepositories = this.getLocalRepositories(configuration);
        for (LocalRepository localRepository : localRepositories) {
            if (!localRepository.hasCloneUrl(cloneUrl)) continue;
            return localRepository;
        }
        return null;
    }
}

