/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.ModifyFilesCommandSupport;
import io.fabric8.updatebot.kind.CompositeUpdater;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.kind.Updater;
import io.fabric8.updatebot.repository.LocalRepository;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandNames={"pull"}, commandDescription="Pulls version changes into your projects. Lets you periodically query all the dependencies for all your projects and pull any upstream releases into your projects")
public class PullVersionChanges
extends ModifyFilesCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullVersionChanges.class);
    @Parameter(order=0, names={"--kind", "-k"}, description="The kind of property to replace based on the kind of language or build tool. If not specified then all supported languages and build tools will be updated")
    private Kind kind;
    private Updater updater;

    @Override
    protected boolean doProcess(CommandContext context) throws IOException {
        LocalRepository repository = context.getRepository();
        LOG.debug("Pulling version changes into: " + repository.getDir() + " repo: " + repository.getCloneUrl());
        return this.getUpdater().pullVersions(context);
    }

    protected Updater getUpdater() {
        if (this.updater == null) {
            this.updater = this.kind != null ? this.kind.getUpdater() : new CompositeUpdater();
        }
        return this.updater;
    }
}

