/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.CommandSupport;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.github.Issues;
import io.fabric8.updatebot.github.PullRequests;
import io.fabric8.updatebot.kind.DependenciesCheck;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.kind.KindDependenciesCheck;
import io.fabric8.updatebot.kind.Updater;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModifyFilesCommandSupport
extends CommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(ModifyFilesCommandSupport.class);
    private GHIssue issue;

    @Override
    public void run(CommandContext context) throws IOException {
        this.prepareDirectory(context);
        if (this.doProcess(context) && !context.getConfiguration().isDryRun()) {
            this.gitCommitAndPullRequest(context);
        }
    }

    public void run(CommandContext context, GHRepository ghRepository, GHPullRequest pullRequest) throws IOException {
        this.prepareDirectory(context);
        if (this.doProcess(context)) {
            this.processPullRequest(context, ghRepository, pullRequest);
        }
    }

    protected void prepareDirectory(CommandContext context) {
        File dir = context.getRepository().getDir();
        dir.getParentFile().mkdirs();
        context.getGit().stashAndCheckoutMaster(dir);
    }

    protected boolean doProcess(CommandContext context) throws IOException {
        return false;
    }

    protected void gitCommitAndPullRequest(CommandContext context) throws IOException {
        GHRepository ghRepository = context.gitHubRepository();
        if (ghRepository != null) {
            List<GHPullRequest> pullRequests = PullRequests.getOpenPullRequests(ghRepository, context.getConfiguration());
            GHPullRequest pullRequest = this.findPullRequest(context, pullRequests);
            this.processPullRequest(context, ghRepository, pullRequest);
        }
    }

    protected void processPullRequest(CommandContext context, GHRepository ghRepository, GHPullRequest pullRequest) throws IOException {
        Configuration configuration = context.getConfiguration();
        String title = context.createPullRequestTitle();
        String remoteURL = "git@github.com:" + ghRepository.getOwnerName() + "/" + ghRepository.getName();
        File dir = context.getDir();
        context.getGit().setRemoteURL(dir, remoteURL);
        String commandComment = this.createPullRequestComment();
        if (pullRequest == null) {
            String localBranch = "updatebot-" + UUID.randomUUID().toString();
            this.doCommit(context, dir, localBranch);
            String body = context.createPullRequestBody();
            String head = localBranch;
            if (!context.getGit().push(dir, localBranch)) {
                context.warn(LOG, "Failed to push branch " + localBranch + " for " + context.getCloneUrl());
                return;
            }
            pullRequest = ghRepository.createPullRequest(title, head, "master", body);
            context.setPullRequest(pullRequest);
            context.info(LOG, "Created pull request " + pullRequest.getHtmlUrl());
            pullRequest.comment(commandComment);
            this.addIssueClosedCommentIfRequired(context, pullRequest, true);
            pullRequest.setLabels(new String[]{configuration.getGithubPullRequestLabel()});
        } else {
            String remoteRef;
            context.setPullRequest(pullRequest);
            this.addIssueClosedCommentIfRequired(context, pullRequest, false);
            String oldTitle = pullRequest.getTitle();
            if (Objects.equal((Object)oldTitle, (Object)title)) {
                if (configuration.isRebaseMode()) {
                    if (GitHubHelpers.isMergeable(pullRequest)) {
                        return;
                    }
                    pullRequest.comment("[UpdateBot](https://github.com/fabric8io/updatebot) rebasing due to merge conflicts");
                }
            } else {
                pullRequest.setTitle(title);
                pullRequest.comment(commandComment);
            }
            GHCommitPointer head = pullRequest.getHead();
            String localBranch = remoteRef = head.getRef();
            context.getGit().deleteBranch(dir, localBranch);
            this.doCommit(context, dir, localBranch);
            if (!context.getGit().push(dir, localBranch + ":" + remoteRef)) {
                context.warn(LOG, "Failed to push branch " + localBranch + " to existing github branch " + remoteRef + " for " + pullRequest.getHtmlUrl());
            }
            context.info(LOG, "Updated PR " + pullRequest.getHtmlUrl());
        }
    }

    private void addIssueClosedCommentIfRequired(CommandContext context, GHPullRequest pullRequest, boolean create) {
        GHIssue issue = context.getIssue();
        if (issue == null) {
            return;
        }
        if (!create) {
            try {
                List comments = pullRequest.getComments();
                for (GHIssueComment comment : comments) {
                    String body = comment.getBody();
                    if (body == null || !body.startsWith(PullRequests.ISSUE_LINK_COMMENT)) continue;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            pullRequest.comment(PullRequests.ISSUE_LINK_COMMENT + " " + issue.getHtmlUrl() + PullRequests.ISSUE_LINK_COMMENT_SUFFIX);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean doCommit(CommandContext context, File dir, String branch) {
        String commitComment = context.createCommit();
        return context.getGit().commitToBranch(dir, branch, commitComment);
    }

    protected GHPullRequest findPullRequest(CommandContext context, List<GHPullRequest> pullRequests) {
        String prefix = context.createPullRequestTitlePrefix();
        if (pullRequests != null) {
            for (GHPullRequest pullRequest : pullRequests) {
                String title = pullRequest.getTitle();
                if (title == null || !title.startsWith(prefix)) continue;
                return pullRequest;
            }
        }
        return null;
    }

    protected boolean pushVersionChangesWithoutChecks(CommandContext parentContext, List<DependencyVersionChange> steps) throws IOException {
        boolean answer = false;
        Map<Kind, List<DependencyVersionChange>> map = DependencyVersionChange.byKind(steps);
        for (Map.Entry<Kind, List<DependencyVersionChange>> entry : map.entrySet()) {
            Kind kind = entry.getKey();
            List<DependencyVersionChange> changes = entry.getValue();
            Updater updater = kind.getUpdater();
            if (!updater.pushVersions(parentContext, changes)) continue;
            answer = true;
        }
        return answer;
    }

    protected boolean pushVersionsWithChecks(CommandContext context, List<DependencyVersionChange> originalSteps) throws IOException {
        List<DependencyVersionChange> pendingChanges = this.loadPendingChanges(context);
        List<DependencyVersionChange> steps = this.combinePendingChanges(originalSteps, pendingChanges);
        boolean answer = this.pushVersionChangesWithoutChecks(context, steps);
        if (answer && context.getConfiguration().isCheckDependencies()) {
            DependenciesCheck check = this.checkDependencyChanges(context, steps);
            List<DependencyVersionChange> invalidChanges = check.getInvalidChanges();
            List<DependencyVersionChange> validChanges = check.getValidChanges();
            if (invalidChanges.size() > 0) {
                context.getGit().revertChanges(context.getDir());
                if (validChanges.size() > 0 && !this.pushVersionChangesWithoutChecks(context, validChanges)) {
                    context.warn(LOG, "Attempted to apply the subset of valid changes " + DependencyVersionChange.describe(validChanges) + " but no files were modified!");
                    return false;
                }
            }
            this.updatePendingChanges(context, check, pendingChanges);
            return validChanges.size() > 0;
        }
        return answer;
    }

    public void updatePendingChanges(CommandContext context, DependenciesCheck check, List<DependencyVersionChange> pendingChanges) throws IOException {
        List<DependencyVersionChange> currentPendingChanges = check.getInvalidChanges();
        GHRepository ghRepository = context.gitHubRepository();
        if (ghRepository != null) {
            GHIssue issue = this.getOrFindIssue(context, ghRepository);
            if (currentPendingChanges.equals(pendingChanges)) {
                if (issue != null) {
                    LOG.debug("Pending changes unchanged so not modifying the issue");
                }
                return;
            }
            String operationDescrption = this.getOperationDescription(context);
            if (currentPendingChanges.isEmpty()) {
                if (issue != null) {
                    context.info(LOG, "Closing issue as we have no further pending issues " + issue.getHtmlUrl());
                    issue.comment("[UpdateBot](https://github.com/fabric8io/updatebot) closing as no more dependency conflicts while " + operationDescrption);
                    issue.close();
                }
                return;
            }
            if (issue == null) {
                issue = Issues.createIssue(context, ghRepository);
                context.setIssue(issue);
                context.info(LOG, "Created issue " + issue.getHtmlUrl());
            } else {
                context.info(LOG, "Modifying issue " + issue.getHtmlUrl());
            }
            Issues.addConflictsComment(issue, currentPendingChanges, operationDescrption, check);
        }
    }

    protected String getOperationDescription(CommandContext context) {
        return "pushing versions";
    }

    private List<DependencyVersionChange> combinePendingChanges(List<DependencyVersionChange> changes, List<DependencyVersionChange> pendingChanges) {
        if (pendingChanges.isEmpty()) {
            return changes;
        }
        ArrayList<DependencyVersionChange> answer = new ArrayList<DependencyVersionChange>(changes);
        for (DependencyVersionChange pendingStep : pendingChanges) {
            if (DependencyVersionChange.hasDependency(changes, pendingStep)) continue;
            answer.add(pendingStep);
        }
        return answer;
    }

    protected List<DependencyVersionChange> loadPendingChanges(CommandContext context) throws IOException {
        List<GHIssue> issues;
        GHIssue issue;
        GHRepository ghRepository = context.gitHubRepository();
        if (ghRepository != null && (issue = Issues.findIssue(context, issues = Issues.getOpenIssues(ghRepository, context.getConfiguration()))) != null) {
            context.setIssue(issue);
            return Issues.loadPendingChangesFromIssue(context, issue);
        }
        return new ArrayList<DependencyVersionChange>();
    }

    protected DependenciesCheck checkDependencyChanges(CommandContext context, List<DependencyVersionChange> steps) {
        LinkedHashMap<Kind, ArrayList<DependencyVersionChange>> map = new LinkedHashMap<Kind, ArrayList<DependencyVersionChange>>();
        for (DependencyVersionChange change : steps) {
            Kind kind = change.getKind();
            ArrayList<DependencyVersionChange> list = (ArrayList<DependencyVersionChange>)map.get((Object)kind);
            if (list == null) {
                list = new ArrayList<DependencyVersionChange>();
                map.put(kind, list);
            }
            list.add(change);
        }
        ArrayList<DependencyVersionChange> validChanges = new ArrayList<DependencyVersionChange>();
        ArrayList<DependencyVersionChange> invalidChanges = new ArrayList<DependencyVersionChange>();
        LinkedHashMap<Kind, KindDependenciesCheck> allResults = new LinkedHashMap<Kind, KindDependenciesCheck>();
        for (Map.Entry entry : map.entrySet()) {
            Kind kind = (Kind)((Object)entry.getKey());
            Updater updater = kind.getUpdater();
            KindDependenciesCheck results = updater.checkDependencies(context, (List)entry.getValue());
            validChanges.addAll(results.getValidChanges());
            invalidChanges.addAll(results.getInvalidChanges());
            allResults.put(kind, results);
        }
        return new DependenciesCheck(validChanges, invalidChanges, allResults);
    }
}

