/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.CommandSupport;
import io.fabric8.updatebot.commands.ModifyFilesCommandSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;

public class CompositeCommand
extends CommandSupport {
    private List<CommandSupport> commands = new ArrayList<CommandSupport>();

    @Override
    protected void appendPullRequestComment(StringBuilder builder) {
        for (CommandSupport child : this.getCommands()) {
            child.appendPullRequestComment(builder);
        }
    }

    @Override
    public String createPullRequestComment() {
        StringBuilder builder = new StringBuilder("[UpdateBot](https://github.com/fabric8io/updatebot) commands:");
        builder.append("\n\n");
        boolean first = true;
        for (CommandSupport child : this.getCommands()) {
            builder.append("    updatebot ");
            builder.append(child.createPullRequestComment());
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void run(CommandContext originalContext) throws IOException {
        CommandContext parentContext = new CommandContext(originalContext.getRepository(), originalContext.getConfiguration());
        for (CommandSupport command : this.getCommands()) {
            File dir = parentContext.getRepository().getDir();
            dir.getParentFile().mkdirs();
            command.run(parentContext);
        }
    }

    public void run(CommandContext context, GHRepository ghRepository, GHPullRequest pullRequest) throws IOException {
        for (CommandSupport command : this.getCommands()) {
            command.validateConfiguration(context.getConfiguration());
            if (!(command instanceof ModifyFilesCommandSupport)) continue;
            ModifyFilesCommandSupport modifyCommand = (ModifyFilesCommandSupport)command;
            modifyCommand.run(context, ghRepository, pullRequest);
        }
    }

    public List<CommandSupport> getCommands() {
        return this.commands;
    }

    public void addCommand(CommandSupport command) {
        this.commands.add(command);
    }
}

