/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.CommandContext;
import io.fabric8.updatebot.commands.ParentContext;
import io.fabric8.updatebot.github.Issues;
import io.fabric8.updatebot.model.RepositoryConfig;
import io.fabric8.updatebot.model.RepositoryConfigs;
import io.fabric8.updatebot.repository.LocalRepository;
import io.fabric8.updatebot.repository.Repositories;
import io.fabric8.updatebot.support.ReflectionHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHRepository;

public abstract class CommandSupport {
    private List<LocalRepository> localRepositories;
    private RepositoryConfig repositoryConfig;

    public String createPullRequestComment() {
        StringBuilder builder = new StringBuilder("[UpdateBot](https://github.com/fabric8io/updatebot) commands:");
        builder.append("\n\n");
        this.appendPullRequestComment(builder);
        return builder.toString();
    }

    protected void appendPullRequestComment(StringBuilder builder) {
        String[] commandNames;
        builder.append("    updatebot ");
        Parameters annotation = this.getClass().getAnnotation(Parameters.class);
        if (annotation != null && (commandNames = annotation.commandNames()) != null && commandNames.length > 0) {
            builder.append(commandNames[0]);
        }
        this.appendPullRequestCommentArguments(builder);
        builder.append("\n");
    }

    protected void appendPullRequestCommentArguments(StringBuilder builder) {
        List<Field> fields = ReflectionHelper.findFieldsAnnotatedWith(this.getClass(), Parameter.class);
        this.appendPullRequestsCommentArguments(builder, fields, true);
        this.appendPullRequestsCommentArguments(builder, fields, false);
    }

    private void appendPullRequestsCommentArguments(StringBuilder builder, List<Field> fields, boolean namedArguments) {
        for (Field field : fields) {
            Object value;
            Parameter parameter = field.getAnnotation(Parameter.class);
            String[] names = parameter.names();
            if (names.length > 0) {
                String name = names[0];
                if (!namedArguments) continue;
                builder.append(" ");
                builder.append(name);
            } else if (namedArguments) continue;
            if ((value = ReflectionHelper.getFieldValue(field, this)) == null) continue;
            builder.append(" ");
            if (value instanceof Collection) {
                builder.append(Strings.join((Collection)((Collection)value), (String)" "));
                continue;
            }
            if (value instanceof Object[]) {
                builder.append(Strings.join((String)" ", (Object[])((Object[])value)));
                continue;
            }
            builder.append(value);
        }
    }

    public ParentContext run(Configuration configuration) throws IOException {
        this.validateConfiguration(configuration);
        ParentContext parentContext = new ParentContext();
        List<LocalRepository> repositories = this.cloneOrPullRepositories(configuration);
        for (LocalRepository repository : repositories) {
            CommandContext context = this.createCommandContext(repository, configuration);
            parentContext.addChild(context);
            this.run(context);
        }
        return parentContext;
    }

    protected void validateConfiguration(Configuration configuration) throws IOException {
    }

    protected CommandContext createCommandContext(LocalRepository repository, Configuration configuration) {
        return new CommandContext(repository, configuration);
    }

    public abstract void run(CommandContext var1) throws IOException;

    public List<LocalRepository> cloneOrPullRepositories(Configuration configuration) throws IOException {
        return this.getLocalRepositories(configuration);
    }

    public List<LocalRepository> getLocalRepositories(Configuration configuration) throws IOException {
        if (this.localRepositories == null) {
            RepositoryConfig repositoryConfig = this.getRepositoryConfig(configuration);
            this.localRepositories = Repositories.cloneOrPullRepositories(this, configuration, repositoryConfig);
        }
        return this.localRepositories;
    }

    public RepositoryConfig getRepositoryConfig(Configuration configuration) throws IOException {
        if (this.repositoryConfig == null) {
            String configFile = configuration.getConfigFile();
            File sourceDir = configuration.getSourceDir();
            this.repositoryConfig = RepositoryConfigs.loadRepositoryConfig(configFile, sourceDir);
        }
        return this.repositoryConfig;
    }

    protected GHIssue getOrFindIssue(CommandContext context, GHRepository ghRepository) throws IOException {
        GHIssue issue = context.getIssue();
        if (issue == null) {
            List<GHIssue> issues = Issues.getOpenIssues(ghRepository, context.getConfiguration());
            issue = Issues.findIssue(context, issues);
            context.setIssue(issue);
        }
        return issue;
    }
}

