/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.updatebot.commands;

import io.fabric8.updatebot.Configuration;
import io.fabric8.updatebot.commands.PushVersionChangesContext;
import io.fabric8.updatebot.commands.Status;
import io.fabric8.updatebot.git.GitPlugin;
import io.fabric8.updatebot.github.GitHubHelpers;
import io.fabric8.updatebot.kind.Kind;
import io.fabric8.updatebot.model.DependencyVersionChange;
import io.fabric8.updatebot.repository.LocalRepository;
import io.fabric8.updatebot.support.Strings;
import io.fabric8.utils.Objects;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static final transient Logger LOG = LoggerFactory.getLogger(CommandContext.class);
    private final LocalRepository repository;
    private final Configuration configuration;
    private final Set<File> updatedFiles = new TreeSet<File>();
    private final CommandContext parentContext;
    private List<CommandContext> children = new ArrayList<CommandContext>();
    private GHIssue issue;
    private GHPullRequest pullRequest;
    private Status status = Status.PENDING;

    public CommandContext(LocalRepository repository, Configuration configuration) {
        this.repository = repository;
        this.configuration = configuration;
        this.parentContext = null;
    }

    public CommandContext(CommandContext parentContext) {
        this.repository = parentContext.getRepository();
        this.configuration = parentContext.getConfiguration();
        this.parentContext = parentContext;
        this.parentContext.addChild(this);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public CommandContext getParentContext() {
        return this.parentContext;
    }

    public List<CommandContext> getChildren() {
        return this.children;
    }

    public LocalRepository getRepository() {
        return this.repository;
    }

    public GHIssue getIssue() {
        return this.issue;
    }

    public void setIssue(GHIssue issue) {
        this.issue = issue;
    }

    public GHPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(GHPullRequest pullRequest) {
        this.pullRequest = pullRequest;
    }

    public String getRepositoryFullName() {
        return this.repository.getRepo().getFullName();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isUpdated() {
        return this.updatedFiles.size() > 0;
    }

    public Set<File> getUpdatedFiles() {
        return this.updatedFiles;
    }

    public String getCloneUrl() {
        return this.repository.getCloneUrl();
    }

    public File getDir() {
        return this.repository.getDir();
    }

    public GHRepository gitHubRepository() {
        return GitHubHelpers.getGitHubRepository(this.repository);
    }

    public File file(String relativePath) {
        return new File(this.repository.getDir(), relativePath);
    }

    public void updatedFile(File file) {
        this.updatedFiles.add(file);
    }

    public GitPlugin getGit() {
        return this.getConfiguration().getGit();
    }

    public PushVersionChangesContext updateVersion(Kind kind, String name, String version) {
        return new PushVersionChangesContext(this, new DependencyVersionChange(kind, name, version));
    }

    public String createPullRequestTitle() {
        CommandContext child = this.firstChild();
        if (child != null) {
            return child.createPullRequestTitle();
        }
        return "Pulling new versions";
    }

    public String createIssueTitlePrefix() {
        return "UpdateBot found version conflicts";
    }

    public String createPullRequestTitlePrefix() {
        CommandContext child = this.firstChild();
        if (child != null) {
            return child.createPullRequestTitlePrefix();
        }
        return this.createPullRequestTitle();
    }

    public String createCommit() {
        CommandContext child = this.firstChild();
        if (child != null) {
            return child.createCommit();
        }
        return this.createPullRequestTitle();
    }

    public String createPullRequestBody() {
        CommandContext child = this.firstChild();
        if (child != null) {
            return child.createPullRequestBody();
        }
        return "generated by [UpdateBot](https://github.com/fabric8io/updatebot)";
    }

    protected void addChild(CommandContext child) {
        this.children.add(child);
    }

    public void removeChild(CommandContext child) {
        this.children.remove(child);
    }

    protected CommandContext firstChild() {
        if (!this.children.isEmpty()) {
            return this.children.get(0);
        }
        return null;
    }

    public Map<String, String> createStatusMap() {
        URL htmlUrl;
        StringBuilder builder = new StringBuilder();
        String cloneUrl = this.getRepository().getCloneUrl();
        HashMap<String, String> answer = new HashMap<String, String>();
        if (this.status != null) {
            builder.append((Object)this.status);
            answer.put("status", this.status.toString().toLowerCase());
        }
        if (this.issue != null) {
            htmlUrl = this.issue.getHtmlUrl();
            builder.append(" issue: ");
            builder.append(htmlUrl);
            answer.put("issue", Strings.toString(htmlUrl));
        }
        if (this.pullRequest != null) {
            htmlUrl = this.pullRequest.getHtmlUrl();
            builder.append(" pull request: ");
            builder.append(htmlUrl);
            answer.put("pr", Strings.toString(htmlUrl));
        }
        String message = builder.toString();
        String oldMessage = this.getConfiguration().getPollStatusCache().put(cloneUrl, message);
        if (oldMessage == null && !Objects.equal((Object)oldMessage, (Object)message)) {
            this.info(LOG, message);
        }
        return answer;
    }

    public void info(Logger log, String message) {
        this.getConfiguration().info(log, message);
    }

    public void warn(Logger log, String message) {
        this.getConfiguration().warn(log, message);
    }

    public void warn(Logger log, String message, Throwable e) {
        this.getConfiguration().warn(log, message, e);
    }
}

